/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.impl.DecoratedFileObject;
import org.apache.commons.vfs2.provider.AbstractFileObject;

public final class FileObjectUtils {
    private FileObjectUtils() {
    }

    public static AbstractFileObject getAbstractFileObject(FileObject fileObject) throws FileSystemException {
        FileObject searchObject = fileObject;
        while (searchObject instanceof DecoratedFileObject) {
            searchObject = ((DecoratedFileObject)searchObject).getDecoratedFileObject();
        }
        if (searchObject instanceof AbstractFileObject) {
            return (AbstractFileObject)searchObject;
        }
        if (searchObject == null) {
            return null;
        }
        throw new FileSystemException("vfs.util/find-abstract-file-object.error", fileObject == null ? "null" : fileObject.getClass().getName());
    }

    public static boolean isInstanceOf(FileObject fileObject, Class<?> wantedClass) throws FileSystemException {
        FileObject searchObject = fileObject;
        while (searchObject instanceof DecoratedFileObject) {
            if (wantedClass.isInstance(searchObject)) {
                return true;
            }
            searchObject = ((DecoratedFileObject)searchObject).getDecoratedFileObject();
        }
        return wantedClass.isInstance(searchObject);
    }
}

