/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocType;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.impl.llom.OMSerializableImpl;
import org.apache.axiom.om.impl.llom.factory.OMLinkedListImplFactory;

public abstract class OMNodeImpl
extends OMSerializableImpl
implements OMNode,
OMNodeEx {
    protected OMContainerEx parent;
    protected OMNodeImpl nextSibling;
    protected OMNodeImpl previousSibling;
    protected int nodeType;

    public OMNodeImpl(OMFactory factory) {
        super(factory);
    }

    public OMNodeImpl(OMContainer parent, OMFactory factory, boolean done) {
        super(factory);
        this.done = done;
        if (parent != null) {
            this.parent = (OMContainerEx)parent;
            parent.addChild((OMNode)this);
        }
    }

    public OMContainer getParent() {
        return this.parent;
    }

    public void setParent(OMContainer element) {
        if (this.parent == element) {
            return;
        }
        if (element != null) {
            if (this.parent != null) {
                this.detach();
            }
            this.parent = (OMContainerEx)element;
        } else {
            this.parent = null;
        }
    }

    public OMNode getNextOMSibling() throws OMException {
        if (this.nextSibling == null && this.parent != null && !this.parent.isComplete()) {
            this.parent.buildNext();
        }
        return this.nextSibling;
    }

    public OMNode getNextOMSiblingIfAvailable() {
        return this.nextSibling;
    }

    public void setNextOMSibling(OMNode node) {
        this.nextSibling = node == null || node.getOMFactory() instanceof OMLinkedListImplFactory ? (OMNodeImpl)node : (OMNodeImpl)this.importNode(node);
        this.nextSibling = (OMNodeImpl)node;
    }

    @Override
    public void setComplete(boolean state) {
        this.done = state;
        if (this.parent != null) {
            if (!this.done) {
                this.parent.setComplete(false);
            } else if (this.parent instanceof OMElementImpl) {
                ((OMElementImpl)this.parent).notifyChildComplete();
            }
        }
    }

    public OMNode detach() throws OMException {
        if (this.parent == null) {
            throw new OMException("Nodes that don't have a parent can not be detached");
        }
        OMNodeImpl nextSibling = (OMNodeImpl)this.getNextOMSibling();
        if (this.previousSibling == null) {
            this.parent.setFirstChild((OMNode)nextSibling);
        } else {
            ((OMNodeEx)this.getPreviousOMSibling()).setNextOMSibling((OMNode)nextSibling);
        }
        if (nextSibling != null) {
            nextSibling.setPreviousOMSibling(this.getPreviousOMSibling());
        }
        if (this.parent instanceof OMElementImpl && ((OMElementImpl)this.parent).lastChild == this) {
            ((OMElementImpl)this.parent).lastChild = this.getPreviousOMSibling();
        }
        this.previousSibling = null;
        this.nextSibling = null;
        this.parent = null;
        return this;
    }

    public void insertSiblingAfter(OMNode sibling) throws OMException {
        if (this.parent == null) {
            throw new OMException("Parent can not be null");
        }
        if (this == sibling) {
            throw new OMException("Inserting self as the sibling is not allowed");
        }
        ((OMNodeEx)sibling).setParent((OMContainer)this.parent);
        if (sibling instanceof OMNodeImpl) {
            OMNodeImpl siblingImpl = (OMNodeImpl)sibling;
            if (this.nextSibling == null) {
                this.getNextOMSibling();
            }
            siblingImpl.setPreviousOMSibling(this);
            if (this.nextSibling == null) {
                this.parent.setLastChild(sibling);
            } else {
                this.nextSibling.setPreviousOMSibling(sibling);
            }
            ((OMNodeEx)sibling).setNextOMSibling((OMNode)this.nextSibling);
            this.nextSibling = siblingImpl;
        }
    }

    public void insertSiblingBefore(OMNode sibling) throws OMException {
        if (this.parent == null) {
            throw new OMException("Parent can not be null");
        }
        if (this == sibling) {
            throw new OMException("Inserting self as the sibling is not allowed");
        }
        if (sibling instanceof OMNodeImpl) {
            OMNodeImpl siblingImpl = (OMNodeImpl)sibling;
            if (this.previousSibling == null) {
                this.parent.setFirstChild((OMNode)siblingImpl);
                siblingImpl.nextSibling = this;
                siblingImpl.previousSibling = null;
            } else {
                siblingImpl.setParent((OMContainer)this.parent);
                siblingImpl.nextSibling = this;
                this.previousSibling.setNextOMSibling(siblingImpl);
                siblingImpl.setPreviousOMSibling(this.previousSibling);
            }
            this.previousSibling = siblingImpl;
        }
    }

    public int getType() {
        return this.nodeType;
    }

    public void setType(int nodeType) throws OMException {
        this.nodeType = nodeType;
    }

    public OMNode getPreviousOMSibling() {
        return this.previousSibling;
    }

    public void setPreviousOMSibling(OMNode previousSibling) {
        this.previousSibling = previousSibling == null || previousSibling.getOMFactory() instanceof OMLinkedListImplFactory ? (OMNodeImpl)previousSibling : (OMNodeImpl)this.importNode(previousSibling);
    }

    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
    }

    protected OMNode importNode(OMNode child) {
        int type = child.getType();
        switch (type) {
            case 1: {
                OMElement childElement = (OMElement)child;
                OMElement newElement = new StAXOMBuilder(this.factory, childElement.getXMLStreamReader()).getDocumentElement();
                newElement.buildWithAttachments();
                return newElement;
            }
            case 4: {
                OMText newText;
                OMText importedText = (OMText)child;
                if (importedText.isBinary()) {
                    boolean isOptimize = importedText.isOptimized();
                    newText = this.factory.createOMText(importedText.getDataHandler(), isOptimize);
                } else {
                    newText = importedText.isCharacters() ? this.factory.createOMText(null, importedText.getTextCharacters(), importedText.getType()) : this.factory.createOMText(null, importedText.getText());
                }
                return newText;
            }
            case 3: {
                OMProcessingInstruction importedPI = (OMProcessingInstruction)child;
                return this.factory.createOMProcessingInstruction(null, importedPI.getTarget(), importedPI.getValue());
            }
            case 5: {
                OMComment importedComment = (OMComment)child;
                return this.factory.createOMComment(null, importedComment.getValue());
            }
            case 11: {
                OMDocType importedDocType = (OMDocType)child;
                return this.factory.createOMDocType(null, importedDocType.getValue());
            }
        }
        throw new UnsupportedOperationException("Not Implemented Yet for the given node type");
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, true);
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, false);
    }
}

