/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import com.ctc.wstx.exc.WstxIOException;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.attachments.utils.DataHandlerUtils;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.om.impl.builder.XOPBuilder;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.impl.llom.OMNodeImpl;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.axiom.util.stax.XMLStreamWriterUtils;
import org.apache.commons.text.StringEscapeUtils;

public class OMTextImpl
extends OMNodeImpl
implements OMText,
OMConstants {
    public static final OMNamespace XOP_NS = new OMNamespaceImpl("http://www.w3.org/2004/08/xop/include", "xop");
    protected String value = null;
    protected char[] charArray;
    private boolean calcNS;
    protected OMNamespace textNS;
    protected String mimeType;
    protected boolean optimize = false;
    protected boolean isBinary = false;
    private String contentID = null;
    private Object dataHandlerObject = null;
    private static final String EMTPY_STRING = "";
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSI_PREFIX = "xsi";
    private static final String NIL = "nil";

    public OMTextImpl(String s, OMFactory factory) {
        this(s, 4, factory);
    }

    public OMTextImpl(String s, int nodeType, OMFactory factory) {
        this(null, s, nodeType, factory);
    }

    public OMTextImpl(OMContainer parent, String text, OMFactory factory) {
        this(parent, text, 4, factory);
    }

    public OMTextImpl(OMContainer parent, OMTextImpl source, OMFactory factory) {
        super(parent, factory, true);
        this.value = source.value;
        this.nodeType = source.nodeType;
        if (source.charArray != null) {
            this.charArray = new char[source.charArray.length];
            System.arraycopy(source.charArray, 0, this.charArray, 0, source.charArray.length);
        }
        this.calcNS = false;
        this.textNS = null;
        this.optimize = source.optimize;
        this.mimeType = source.mimeType;
        this.isBinary = source.isBinary;
        this.contentID = source.contentID;
        this.dataHandlerObject = source.dataHandlerObject;
    }

    public OMTextImpl(OMContainer parent, String text, int nodeType, OMFactory factory) {
        super(parent, factory, true);
        if (text == null) {
            this.value = EMTPY_STRING;
            if (parent instanceof OMElementImpl) {
                OMNamespace xsiNameSpace = factory.createOMNamespace(XSI_NAMESPACE, XSI_PREFIX);
                ((OMElementImpl)parent).addAttribute(NIL, "true", xsiNameSpace);
            }
        } else {
            this.value = text;
        }
        this.nodeType = nodeType;
    }

    public OMTextImpl(OMContainer parent, char[] charArray, int nodeType, OMFactory factory) {
        super(parent, factory, true);
        this.charArray = charArray;
        this.nodeType = nodeType;
    }

    public OMTextImpl(OMContainer parent, QName text, OMFactory factory) {
        this(parent, text, 4, factory);
    }

    public OMTextImpl(OMContainer parent, QName text, int nodeType, OMFactory factory) {
        super(parent, factory, true);
        if (text == null) {
            throw new IllegalArgumentException("QName text arg cannot be null!");
        }
        this.calcNS = true;
        this.textNS = ((OMElementImpl)parent).handleNamespace(text.getNamespaceURI(), text.getPrefix());
        this.value = this.textNS.getPrefix() + ":" + text.getLocalPart();
        this.nodeType = nodeType;
    }

    public OMTextImpl(String s, String mimeType, boolean optimize, OMFactory factory) {
        this(null, s, mimeType, optimize, factory);
    }

    public OMTextImpl(OMContainer parent, String s, String mimeType, boolean optimize, OMFactory factory) {
        this(parent, s, factory);
        this.mimeType = mimeType;
        this.optimize = optimize;
        this.isBinary = true;
        this.done = true;
        this.nodeType = 4;
    }

    public OMTextImpl(Object dataHandler, OMFactory factory) {
        this(dataHandler, true, factory);
    }

    public OMTextImpl(Object dataHandler, boolean optimize, OMFactory factory) {
        super(factory);
        this.dataHandlerObject = dataHandler;
        this.isBinary = true;
        this.optimize = optimize;
        this.done = true;
        this.nodeType = 4;
    }

    public OMTextImpl(String contentID, DataHandlerProvider dataHandlerProvider, boolean optimize, OMFactory factory) {
        super(factory);
        this.contentID = contentID;
        this.dataHandlerObject = dataHandlerProvider;
        this.isBinary = true;
        this.optimize = optimize;
        this.done = true;
        this.nodeType = 4;
    }

    public OMTextImpl(String contentID, OMContainer parent, OMXMLParserWrapper builder, OMFactory factory) {
        super(parent, factory, false);
        this.contentID = contentID;
        this.optimize = true;
        this.isBinary = true;
        this.builder = builder;
        this.nodeType = 4;
    }

    private void writeOutput(XMLStreamWriter writer) throws XMLStreamException {
        int type = this.getType();
        if (type == 4 || type == 6) {
            try {
                writer.writeCharacters(this.getText());
            }
            catch (WstxIOException e) {
                writer.writeCharacters(this.encodeJSONReserved(this.getText()));
            }
        } else if (type == 12) {
            writer.writeCData(this.getText());
        } else if (type == 9) {
            writer.writeEntityRef(this.getText());
        }
    }

    public String getText() throws OMException {
        if (this.charArray != null || this.value != null) {
            return this.getTextFromProperPlace();
        }
        try {
            return Base64Utils.encode((DataHandler)((DataHandler)this.getDataHandler()));
        }
        catch (Exception e) {
            throw new OMException((Throwable)e);
        }
    }

    public char[] getTextCharacters() {
        if (this.charArray != null) {
            return this.charArray;
        }
        if (this.value != null) {
            return this.value.toCharArray();
        }
        try {
            return Base64Utils.encodeToCharArray((DataHandler)((DataHandler)this.getDataHandler()));
        }
        catch (IOException ex) {
            throw new OMException((Throwable)ex);
        }
    }

    public boolean isCharacters() {
        return this.charArray != null;
    }

    private String getTextFromProperPlace() {
        return this.charArray != null ? new String(this.charArray) : this.value;
    }

    public QName getTextAsQName() throws OMException {
        return ((OMElement)this.parent).resolveQName(this.getTextFromProperPlace());
    }

    public OMNamespace getNamespace() {
        int colon;
        String text;
        if (this.calcNS) {
            return this.textNS;
        }
        this.calcNS = true;
        if (this.getParent() != null && (text = this.getTextFromProperPlace()) != null && (colon = text.indexOf(58)) > 0) {
            this.textNS = ((OMElementImpl)this.getParent()).findNamespaceURI(text.substring(0, colon));
            if (this.textNS != null) {
                this.charArray = null;
                this.value = text.substring(colon + 1);
            }
        }
        return this.textNS;
    }

    public boolean isOptimized() {
        return this.optimize;
    }

    public void setOptimize(boolean value) {
        this.optimize = value;
        if (value) {
            this.isBinary = true;
        }
    }

    public void setBinary(boolean value) {
        this.isBinary = value;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public Object getDataHandler() {
        if ((this.value != null || this.charArray != null) && this.isBinary) {
            String text = this.getTextFromProperPlace();
            return DataHandlerUtils.getDataHandlerFromText((String)text, (String)this.mimeType);
        }
        if (this.dataHandlerObject == null) {
            if (this.contentID == null) {
                throw new RuntimeException("ContentID is null");
            }
            this.dataHandlerObject = ((XOPBuilder)this.builder).getDataHandler(this.contentID);
        } else if (this.dataHandlerObject instanceof DataHandlerProvider) {
            try {
                this.dataHandlerObject = ((DataHandlerProvider)this.dataHandlerObject).getDataHandler();
            }
            catch (IOException ex) {
                throw new OMException((Throwable)ex);
            }
        }
        return this.dataHandlerObject;
    }

    public InputStream getInputStream() throws OMException {
        if (this.isBinary) {
            InputStream inStream;
            if (this.dataHandlerObject == null) {
                this.getDataHandler();
            }
            DataHandler dataHandler = (DataHandler)this.dataHandlerObject;
            try {
                inStream = dataHandler.getDataSource().getInputStream();
            }
            catch (IOException e) {
                throw new OMException("Cannot get InputStream from DataHandler.", (Throwable)e);
            }
            return inStream;
        }
        throw new OMException("Unsupported Operation");
    }

    public String getContentID() {
        if (this.contentID == null) {
            this.contentID = UIDGenerator.generateContentId();
        }
        return this.contentID;
    }

    @Override
    public void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        if (!this.isBinary) {
            this.writeOutput(writer);
        } else {
            try {
                XMLStreamWriterUtils.writeDataHandler((XMLStreamWriter)writer, (DataHandler)((DataHandler)this.getDataHandler()), (String)this.contentID, (boolean)this.optimize);
            }
            catch (IOException ex) {
                throw new OMException("Error reading data handler", (Throwable)ex);
            }
        }
    }

    public void discard() throws OMException {
        if (this.done) {
            this.detach();
        }
    }

    @Override
    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
        if (this.isOptimized()) {
            this.getDataHandler();
        }
    }

    public void setContentID(String cid) {
        this.contentID = cid;
    }

    private String encodeJSONReserved(String message) {
        return StringEscapeUtils.escapeJava((String)message);
    }
}

