/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.scheduling.StrandMetadata;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BFunctionType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.FPValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.utils.ArrayUtils;
import org.ballerinalang.jvm.values.utils.GetFunction;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.array", version="1.1.0", functionName="map", args={@Argument(name="arr", type=TypeKind.ARRAY), @Argument(name="func", type=TypeKind.FUNCTION)}, returnType={@ReturnType(type=TypeKind.ARRAY)}, isPublic=true)
public class Map {
    private static final StrandMetadata METADATA = new StrandMetadata("ballerina", "lang.array", "1.1.0", "map");

    public static ArrayValue map(Strand strand, ArrayValue arr, FPValue<Object, Object> func) {
        GetFunction getFn;
        BType elemType = ((BFunctionType)func.getType()).retType;
        BArrayType retArrType = new BArrayType(elemType);
        ArrayValueImpl retArr = new ArrayValueImpl(retArrType);
        int size = arr.size();
        BType arrType = arr.getType();
        switch (arrType.getTag()) {
            case 20: {
                getFn = BArray::get;
                break;
            }
            case 32: {
                getFn = BArray::getRefValue;
                break;
            }
            default: {
                throw ArrayUtils.createOpNotSupportedError((BType)arrType, (String)"map()");
            }
        }
        AtomicInteger index = new AtomicInteger(-1);
        BRuntime.getCurrentRuntime().invokeFunctionPointerAsyncIteratively(func, null, METADATA, size, () -> new Object[]{strand, getFn.get(arr, (long)index.incrementAndGet()), true}, arg_0 -> Map.lambda$map$1((ArrayValue)retArr, index, arg_0), () -> Map.lambda$map$2((ArrayValue)retArr));
        return retArr;
    }

    private static /* synthetic */ Object lambda$map$2(ArrayValue retArr) {
        return retArr;
    }

    private static /* synthetic */ void lambda$map$1(ArrayValue retArr, AtomicInteger index, Object result) {
        retArr.add((long)index.get(), result);
    }
}

