/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.compiler.backend.jvm;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.objectweb.asm.util.CheckClassAdapter;

public class ClassVerifier {
    public static Optional<ErrorValue> verify(Map<String, ArrayValue> jarEntries, String jarPath) {
        try {
            URLClassLoader cl = new URLClassLoader(new URL[]{Paths.get(jarPath, new String[0]).toUri().toURL()});
            for (Map.Entry<String, ArrayValue> entries : jarEntries.entrySet()) {
                Optional<ErrorValue> result = ClassVerifier.verify(entries.getValue().getBytes(), cl);
                if (!result.isPresent()) continue;
                return result;
            }
            return Optional.empty();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static Optional<ErrorValue> verify(byte[] bytes, ClassLoader classLoader) {
        ClassReader classReader = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)new CheckClassAdapter(458752, (ClassVisitor)classNode, false){}, 2);
        Type syperType = classNode.superName == null ? null : Type.getObjectType((String)classNode.superName);
        List methods = classNode.methods;
        ArrayList<Type> interfaces = new ArrayList<Type>();
        for (String interfaceName : classNode.interfaces) {
            interfaces.add(Type.getObjectType((String)interfaceName));
        }
        for (MethodNode method : methods) {
            SimpleVerifier verifier = new SimpleVerifier(Type.getObjectType((String)classNode.name), syperType, interfaces, (classNode.access & 0x200) != 0);
            Analyzer analyzer = new Analyzer((Interpreter)verifier);
            if (classLoader != null) {
                verifier.setClassLoader(classLoader);
            }
            try {
                analyzer.analyze(classNode.name, method);
            }
            catch (AnalyzerException e) {
                return Optional.of(BallerinaErrors.createError((String)e.getMessage()));
            }
        }
        return Optional.empty();
    }
}

