/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.command;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.bindgen.exceptions.BindgenException;
import org.ballerinalang.bindgen.model.JClass;
import org.ballerinalang.bindgen.model.JError;
import org.ballerinalang.bindgen.utils.BindgenMvnResolver;
import org.ballerinalang.bindgen.utils.BindgenUtils;
import org.ballerinalang.toml.model.Library;
import org.ballerinalang.toml.model.Manifest;
import org.wso2.ballerinalang.util.TomlParserUtils;

public class BindingsGenerator {
    private Path modulePath;
    private Path projectRoot;
    private Path dependenciesPath;
    private Path utilsDirPath;
    private String mvnGroupId;
    private String mvnArtifactId;
    private String mvnVersion;
    private String accessModifier;
    private PrintStream errStream;
    private PrintStream outStream;
    private Set<String> classNames = new HashSet<String>();
    private static String outputPath;
    private static boolean directJavaClass;
    private static Set<String> classPaths;
    private static Path userDir;
    private static Set<String> allClasses;
    private static Set<String> classListForLooping;
    private static Set<String> allJavaClasses;
    private static Set<JError> exceptionList;
    private static Map<String, String> failedClassGens;
    public static Map<String, String> aliases;

    BindingsGenerator(PrintStream out, PrintStream err) {
        this.outStream = out;
        this.errStream = err;
    }

    void generateJavaBindings() throws BindgenException {
        ClassLoader classLoader;
        this.resolvePlatformLibraries();
        if (this.mvnGroupId != null && this.mvnArtifactId != null && this.mvnVersion != null) {
            new BindgenMvnResolver(this.outStream).mavenResolver(this.mvnGroupId, this.mvnArtifactId, this.mvnVersion, this.projectRoot, true);
        }
        if ((classLoader = this.setClassLoader()) != null) {
            this.setDirectoryPaths();
            this.outStream.println("\nGenerating bindings for: ");
            this.generateBindings(this.classNames, classLoader, this.modulePath);
            if (!classListForLooping.isEmpty()) {
                this.outStream.println("\nGenerating dependency bindings for: ");
                BindingsGenerator.setDependentJavaClass();
            }
            while (!classListForLooping.isEmpty()) {
                HashSet<String> newSet = new HashSet<String>(classListForLooping);
                newSet.removeAll(this.classNames);
                List<String> existingBindings = BindgenUtils.getExistingBindings(newSet, this.modulePath.toFile());
                newSet.removeAll(existingBindings);
                allJavaClasses.addAll(newSet);
                classListForLooping.clear();
                this.generateBindings(newSet, classLoader, this.dependenciesPath);
            }
            this.generateUtilFiles();
            if (failedClassGens != null) {
                this.handleFailedClassGens();
            }
            try {
                ((URLClassLoader)classLoader).close();
            }
            catch (IOException e) {
                this.outStream.println("\nError while exiting the classloader:\n" + e.getMessage());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private void resolvePlatformLibraries() throws BindgenException {
        List platformLibraries;
        Manifest manifest;
        if (this.projectRoot != null && (manifest = TomlParserUtils.getManifest((Path)this.projectRoot)) != null && (platformLibraries = manifest.getPlatform().getLibraries()) != null) {
            for (Library library : platformLibraries) {
                if (library.path != null) {
                    classPaths.add(Paths.get(this.projectRoot.toString(), library.path).toString());
                    continue;
                }
                if (library.groupId == null || library.artifactId == null || library.version == null) continue;
                new BindgenMvnResolver(this.outStream).mavenResolver(library.groupId, library.artifactId, library.version, this.projectRoot, false);
            }
        }
    }

    private ClassLoader setClassLoader() throws BindgenException {
        ClassLoader classLoader;
        try {
            if (!classPaths.isEmpty()) {
                classLoader = BindgenUtils.getClassLoader(classPaths, this.getClass().getClassLoader());
            } else {
                this.outStream.println("\nNo classpaths were detected.");
                classLoader = this.getClass().getClassLoader();
            }
        }
        catch (BindgenException e) {
            throw new BindgenException("Error while loading the classpaths.", e);
        }
        return classLoader;
    }

    private void setDirectoryPaths() throws BindgenException {
        String userPath = userDir.toString();
        if (outputPath != null) {
            if (!Paths.get(outputPath, new String[0]).toFile().exists()) {
                throw new BindgenException("Output path provided [" + outputPath + "] could not be found.");
            }
            userPath = outputPath;
        }
        this.modulePath = Paths.get(userPath, "ballerina_bindings", "bindings");
        this.dependenciesPath = Paths.get(userPath, "ballerina_bindings", "dependencies");
        this.utilsDirPath = Paths.get(userPath, "ballerina_bindings", "utils");
    }

    private void handleFailedClassGens() {
        this.errStream.print("\n");
        for (Map.Entry<String, String> entry : failedClassGens.entrySet()) {
            if (!this.classNames.contains(entry.getKey())) continue;
            this.errStream.println("Bindings for '" + entry.getKey() + "' class could not be generated.\n\t" + entry.getValue() + "\n");
        }
    }

    private void generateUtilFiles() throws BindgenException {
        String utilsDirStrPath = this.utilsDirPath.toString();
        BindgenUtils.createDirectory(utilsDirStrPath);
        BindgenUtils.createDirectory(Paths.get(utilsDirStrPath, "error_types").toString());
        Path constantsPath = Paths.get(this.utilsDirPath.toString(), "Constants.bal");
        HashSet<String> names = new HashSet<String>(allClasses);
        if (constantsPath.toFile().exists()) {
            BindgenUtils.getUpdatedConstantsList(constantsPath, names);
            BindgenUtils.notifyExistingDependencies(this.classNames, this.dependenciesPath.toFile());
        }
        if (!names.isEmpty()) {
            BindgenUtils.writeOutputFile(names, "/templates", "constants", constantsPath.toString(), true);
        }
        for (JError jError : exceptionList) {
            jError.setAccessModifier(this.accessModifier);
            String fileName = jError.getShortExceptionName() + ".bal";
            BindgenUtils.writeOutputFile(jError, "/templates", "exception", Paths.get(utilsDirStrPath, "error_types", fileName).toString(), false);
        }
    }

    static void setOutputPath(String output) {
        outputPath = output;
    }

    void setDependentJars(String[] jarPaths) {
        Collections.addAll(classPaths, jarPaths);
    }

    void setClassNames(List<String> classNames) {
        this.classNames = new HashSet<String>(classNames);
    }

    private void generateBindings(Set<String> classList, ClassLoader classLoader, Path modulePath) throws BindgenException {
        BindgenUtils.createDirectory(modulePath.toString());
        for (String c : classList) {
            try {
                Class<?> classInstance;
                if (classLoader == null || (classInstance = classLoader.loadClass(c)) == null || !BindgenUtils.isPublicClass(classInstance)) continue;
                JClass jClass = new JClass(classInstance);
                jClass.setAccessModifier(this.accessModifier);
                String outputFile = Paths.get(modulePath.toString(), jClass.getPackageName()).toString();
                BindgenUtils.createDirectory(outputFile);
                String filePath = Paths.get(outputFile, jClass.getShortClassName() + ".bal").toString();
                BindgenUtils.writeOutputFile(jClass, "/templates", "bridge_class", filePath, false);
                this.outStream.println("\t" + c);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                failedClassGens.put(c, e.toString());
            }
            catch (BindgenException e) {
                throw new BindgenException("Error while generating Ballerina bridge code: " + e);
            }
        }
    }

    public static boolean isDirectJavaClass() {
        return directJavaClass;
    }

    private static void setDependentJavaClass() {
        directJavaClass = false;
    }

    public static Set<String> getAllJavaClasses() {
        return allJavaClasses;
    }

    public static void setClassListForLooping(String classListForLooping) {
        BindingsGenerator.classListForLooping.add(classListForLooping);
    }

    public static void setAllClasses(String allClasses) {
        BindingsGenerator.allClasses.add(allClasses);
    }

    public static void setExceptionList(JError exception) {
        exceptionList.add(exception);
    }

    void setProjectRoot(Path projectRoot) {
        this.projectRoot = projectRoot;
    }

    void setMvnGroupId(String mvnGroupId) {
        this.mvnGroupId = mvnGroupId;
    }

    void setMvnArtifactId(String mvnArtifactId) {
        this.mvnArtifactId = mvnArtifactId;
    }

    void setMvnVersion(String mvnVersion) {
        this.mvnVersion = mvnVersion;
    }

    public static void setClassPaths(String classPath) {
        classPaths.add(classPath);
    }

    public static String getOutputPath() {
        return outputPath;
    }

    void setPublic() {
        this.accessModifier = "public ";
    }

    static {
        directJavaClass = true;
        classPaths = new HashSet<String>();
        userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        allClasses = new HashSet<String>();
        classListForLooping = new HashSet<String>();
        allJavaClasses = new HashSet<String>();
        exceptionList = new HashSet<JError>();
        failedClassGens = new HashMap<String, String>();
        aliases = new HashMap<String, String>();
    }
}

