/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.bindgen.command.BindingsGenerator;
import org.ballerinalang.bindgen.model.JConstructor;
import org.ballerinalang.bindgen.model.JField;
import org.ballerinalang.bindgen.model.JMethod;
import org.ballerinalang.bindgen.utils.BindgenUtils;

public class JClass {
    private String prefix;
    private String className;
    private String packageName;
    private String accessModifier;
    private String shortClassName;
    private boolean isInterface = false;
    private boolean isDirectClass = false;
    private boolean isAbstract = false;
    private boolean importJavaArraysModule = false;
    private Set<String> superClasses = new HashSet<String>();
    private Set<String> superClassNames = new LinkedHashSet<String>();
    private List<JField> fieldList = new ArrayList<JField>();
    private List<JMethod> methodList = new ArrayList<JMethod>();
    private List<JConstructor> constructorList = new ArrayList<JConstructor>();
    private List<JConstructor> initFunctionList = new ArrayList<JConstructor>();
    private Map<String, Integer> overloadedMethods = new HashMap<String, Integer>();

    public JClass(Class c) {
        this.className = c.getName();
        this.prefix = this.className.replace(".", "_").replace("$", "_");
        this.shortClassName = BindgenUtils.getAlias(c);
        this.packageName = c.getPackage().getName();
        this.shortClassName = this.getExceptionName(c, this.shortClassName);
        this.superClassNames.add(c.getName());
        BindingsGenerator.setAllClasses(this.shortClassName);
        if (c.isInterface()) {
            this.isInterface = true;
            BindingsGenerator.setAllClasses(BindgenUtils.getAlias(Object.class));
            this.superClassNames.add(Object.class.getName());
            this.superClasses.add(BindgenUtils.getAlias(Object.class));
        }
        this.populateImplementedInterfaces(c.getInterfaces());
        for (Class sClass = c.getSuperclass(); sClass != null; sClass = sClass.getSuperclass()) {
            this.populateImplementedInterfaces(sClass.getInterfaces());
            String simpleClassName = BindgenUtils.getAlias(sClass).replace("$", "");
            this.superClassNames.add(sClass.getName());
            this.superClasses.add(simpleClassName);
            BindingsGenerator.setAllClasses(simpleClassName);
        }
        if (BindgenUtils.isAbstractClass(c)) {
            this.isAbstract = true;
        }
        if (BindingsGenerator.isDirectJavaClass()) {
            this.isDirectClass = true;
            this.populateConstructors(c.getConstructors());
            this.populateInitFunctions();
            this.populateMethodsInOrder(c);
            this.populateFields(c.getFields());
        }
    }

    private void populateMethodsInOrder(Class c) {
        Map<Method, String> methodClassMap = this.getMethodsAsMap(c);
        LinkedList<String> list = new LinkedList<String>(this.superClassNames);
        Iterator<String> iterator = list.descendingIterator();
        while (iterator.hasNext()) {
            String superclass = iterator.next();
            if (!methodClassMap.containsValue(superclass)) continue;
            ArrayList<JMethod> jMethods = new ArrayList<JMethod>();
            ArrayList<Method> methods = new ArrayList<Method>();
            for (Map.Entry<Method, String> mapValue : methodClassMap.entrySet()) {
                if (!mapValue.getValue().equals(superclass)) continue;
                jMethods.add(new JMethod(mapValue.getKey()));
                methods.add(mapValue.getKey());
            }
            this.populateMethods(methods);
            this.methodList.sort(Comparator.comparing(JMethod::getParamTypes));
            jMethods.sort(Comparator.comparing(JMethod::getParamTypes));
            BindgenUtils.handleOverloadedMethods(this.methodList, jMethods, this);
            this.methodList.sort(Comparator.comparing(JMethod::getMethodName));
        }
    }

    private String getExceptionName(Class exception, String name) {
        try {
            if (this.getClass().getClassLoader().loadClass(Exception.class.getCanonicalName()).isAssignableFrom(exception)) {
                return "J" + name;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return name;
    }

    private Map<Method, String> getMethodsAsMap(Class classObject) {
        Method[] declaredMethods = classObject.getMethods();
        HashMap<Method, String> classMethods = new HashMap<Method, String>();
        for (Method m : declaredMethods) {
            if (m.isSynthetic() || m.getName().equals("toString")) continue;
            classMethods.put(m, m.getDeclaringClass().getName());
        }
        return classMethods;
    }

    private void populateConstructors(Constructor[] constructors) {
        int i = 1;
        for (Constructor constructor : constructors) {
            JConstructor jConstructor = new JConstructor(constructor);
            this.constructorList.add(jConstructor);
            if (!jConstructor.requireJavaArrays()) continue;
            this.importJavaArraysModule = true;
        }
        this.constructorList.sort(Comparator.comparing(JConstructor::getParamTypes));
        for (JConstructor jConstructor : this.constructorList) {
            jConstructor.setConstructorName("new" + this.shortClassName + i);
            jConstructor.setShortClassName(this.shortClassName);
            ++i;
        }
    }

    private void populateInitFunctions() {
        int j = 1;
        for (JConstructor constructor : this.constructorList) {
            JConstructor newCons = null;
            try {
                newCons = (JConstructor)constructor.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (newCons != null) {
                newCons.setExternalFunctionName(constructor.getConstructorName());
                newCons.setConstructorName("" + j);
                this.initFunctionList.add(newCons);
            }
            ++j;
        }
    }

    private void populateMethods(List<Method> declaredMethods) {
        for (Method method : declaredMethods) {
            if (!BindgenUtils.isPublicMethod(method)) continue;
            JMethod jMethod = new JMethod(method);
            jMethod.setShortClassName(this.shortClassName);
            if (jMethod.requireJavaArrays()) {
                this.importJavaArraysModule = true;
            }
            this.methodList.add(jMethod);
        }
    }

    private void populateFields(Field[] fields) {
        boolean addField = true;
        for (Field field : fields) {
            for (JField jField : this.fieldList) {
                if (!jField.getFieldName().equals(field.getName())) continue;
                addField = false;
            }
            if (!addField) continue;
            JField jFieldGetter = new JField(field, "access");
            this.fieldList.add(jFieldGetter);
            if (jFieldGetter.requireJavaArrays()) {
                this.importJavaArraysModule = true;
            }
            if (BindgenUtils.isFinalField(field) || !BindgenUtils.isPublicField(field)) continue;
            this.fieldList.add(new JField(field, "mutate"));
        }
    }

    private void populateImplementedInterfaces(Class[] interfaces) {
        for (Class interfaceClass : interfaces) {
            BindingsGenerator.setAllClasses(BindgenUtils.getAlias(interfaceClass));
            this.superClasses.add(BindgenUtils.getAlias(interfaceClass));
            this.superClassNames.add(interfaceClass.getName());
            if (interfaceClass.getInterfaces() == null) continue;
            this.populateImplementedInterfaces(interfaceClass.getInterfaces());
        }
    }

    public String getShortClassName() {
        return this.shortClassName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setAccessModifier(String accessModifier) {
        this.accessModifier = accessModifier;
    }

    public void setMethodCount(String methodName) {
        Integer methodCount = this.overloadedMethods.get(methodName);
        if (methodCount == null) {
            this.overloadedMethods.put(methodName, 1);
        } else {
            this.overloadedMethods.replace(methodName, methodCount + 1);
        }
    }

    public Integer getMethodCount(String methodName) {
        return this.overloadedMethods.get(methodName);
    }
}

