/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bindgen.model;

import java.lang.reflect.Parameter;
import org.ballerinalang.bindgen.command.BindingsGenerator;
import org.ballerinalang.bindgen.utils.BindgenUtils;

public class JParameter {
    private String type;
    private String externalType;
    private String shortTypeName;
    private String componentType;
    private String fieldName;
    private Boolean isObj = false;
    private Boolean hasNext = true;
    private Boolean isString = false;
    private Boolean isObjArray = false;
    private Boolean isStringArray = false;
    private Boolean isPrimitiveArray = false;

    JParameter(Class parameterClass) {
        this.type = parameterClass.getName();
        this.shortTypeName = BindgenUtils.getBallerinaParamType(parameterClass);
        try {
            if (this.getClass().getClassLoader().loadClass(Exception.class.getCanonicalName()).isAssignableFrom(parameterClass)) {
                this.shortTypeName = "J" + this.shortTypeName;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!parameterClass.isPrimitive()) {
            this.isObj = true;
        }
        if (parameterClass.equals(String.class)) {
            this.isString = true;
            this.shortTypeName = "string";
        } else if (parameterClass.equals(String[].class)) {
            this.isStringArray = true;
            this.shortTypeName = "string[]";
        } else if (!parameterClass.isPrimitive()) {
            if (parameterClass.isArray()) {
                this.setArrayAttributes(parameterClass);
            } else {
                String paramType = parameterClass.getName();
                if (!BindingsGenerator.getAllJavaClasses().contains(paramType)) {
                    BindingsGenerator.setClassListForLooping(paramType);
                }
            }
        }
        this.externalType = BindgenUtils.getBallerinaHandleType(parameterClass);
        this.fieldName = "arg";
    }

    JParameter(Parameter parameter) {
        this(parameter.getType());
        this.fieldName = parameter.getName();
    }

    private void setArrayAttributes(Class parameterClass) {
        Class<?> component = parameterClass.getComponentType();
        this.componentType = component.getTypeName();
        if (!parameterClass.getComponentType().isPrimitive()) {
            this.isObjArray = true;
            this.isObj = false;
            String componentClass = parameterClass.getComponentType().getName();
            if (!BindingsGenerator.getAllJavaClasses().contains(componentClass)) {
                BindingsGenerator.setClassListForLooping(componentClass);
            }
        } else {
            this.shortTypeName = BindgenUtils.getPrimitiveArrayType(this.type);
            this.isPrimitiveArray = true;
        }
    }

    void setHasNext(boolean hasNext) {
        this.hasNext = hasNext;
    }

    Boolean isObjArrayParam() {
        return this.isObjArray;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Boolean getIsObj() {
        return this.isObj;
    }

    public Boolean getIsString() {
        return this.isString;
    }

    public Boolean getIsObjArray() {
        return this.isObjArray;
    }

    public Boolean getIsPrimitiveArray() {
        return this.isPrimitiveArray;
    }

    public Boolean getHasNext() {
        return this.hasNext;
    }

    public String getExternalType() {
        return this.externalType;
    }

    public Boolean getIsStringArray() {
        return this.isStringArray;
    }
}

