/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import org.ballerinalang.tool.BLauncherCmd;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="add", description={"Add a new module to Ballerina project"})
public class AddCommand
implements BLauncherCmd {
    private Path userDir;
    private PrintStream errStream;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--template", "-t"})
    private String template = "lib";

    public AddCommand() {
        this.userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        this.errStream = System.err;
        CommandUtil.initJarFs();
    }

    public AddCommand(Path userDir, PrintStream errStream) {
        this(userDir, errStream, RepoUtils.createAndGetHomeReposPath());
    }

    public AddCommand(Path userDir, PrintStream errStream, Path homeCache) {
        this.userDir = userDir;
        this.errStream = errStream;
        CommandUtil.initJarFs();
    }

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"add");
            this.errStream.println(commandUsageInfo);
            return;
        }
        Path projectPath = ProjectUtils.findProjectRoot((Path)this.userDir);
        if (null == projectPath) {
            CommandUtil.printError(this.errStream, "not a ballerina project (or any parent up to mount point)\nYou should run this command inside a ballerina project", null, false);
            return;
        }
        if (null == this.argList) {
            CommandUtil.printError(this.errStream, "The following required arguments were not provided:\n    <module-name>", "ballerina add <module-name> [-t|--template <template-name>]", true);
            return;
        }
        if (1 != this.argList.size()) {
            CommandUtil.printError(this.errStream, "too many arguments.", "ballerina add <project-name>", true);
            return;
        }
        String moduleName = this.argList.get(0);
        boolean matches = ProjectUtils.validateModuleName((String)moduleName);
        if (!matches) {
            CommandUtil.printError(this.errStream, "Invalid module name : '" + moduleName + "' :\nModule name can only contain alphanumerics, underscores and periods and the maximum length is 256 characters", null, false);
            return;
        }
        if (ProjectUtils.isModuleExist((Path)projectPath, (String)moduleName)) {
            CommandUtil.printError(this.errStream, "A module already exists with the given name : '" + moduleName + "' :\nExisting module path " + projectPath.resolve("modules").resolve(moduleName), null, false);
            return;
        }
        if (!this.template.equalsIgnoreCase("service") && !this.template.equalsIgnoreCase("lib")) {
            CommandUtil.printError(this.errStream, "Using Ballerina Central module templates is not yet supported.", null, false);
            return;
        }
        try {
            Path moduleDirPath = projectPath.resolve("modules");
            if (!Files.exists(moduleDirPath, new LinkOption[0])) {
                Files.createDirectory(moduleDirPath, new FileAttribute[0]);
            }
            this.createModule(projectPath, moduleName, this.template);
        }
        catch (AccessDeniedException e) {
            CommandUtil.printError(this.errStream, "error: Error occurred while creating module : Insufficient Permission", null, false);
            return;
        }
        catch (IOException | URISyntaxException e) {
            CommandUtil.printError(this.errStream, "Error occurred while creating module : " + e.getMessage(), null, false);
            return;
        }
        this.errStream.println("Added new ballerina module at '" + this.userDir.relativize(projectPath.resolve("modules").resolve(moduleName)) + "'");
    }

    public String getName() {
        return "add";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("add a new ballerina module");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina add <module-name> [-t|--template <template-name>]\n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private void createModule(Path projectPath, String moduleName, String template) throws IOException, URISyntaxException {
        Path modulePath = projectPath.resolve("modules").resolve(moduleName);
        Files.createDirectories(modulePath, new FileAttribute[0]);
        CommandUtil.applyTemplate(modulePath, template);
        Path source = modulePath.resolve(template.toLowerCase(Locale.getDefault()) + ".bal");
        Files.move(source, source.resolveSibling(ProjectUtils.guessPkgName((String)moduleName) + ".bal"), StandardCopyOption.REPLACE_EXISTING);
    }
}

