/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.TaskExecutor;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.task.CleanTargetDirTask;
import io.ballerina.cli.task.CompileTask;
import io.ballerina.cli.task.CreateBaloTask;
import io.ballerina.cli.task.CreateExecutableTask;
import io.ballerina.cli.task.CreateTargetDirTask;
import io.ballerina.cli.task.RunTestsTask;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.BuildOptionsBuilder;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.SingleFileProject;
import io.ballerina.runtime.internal.launch.LaunchUtils;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import org.ballerinalang.tool.BLauncherCmd;
import picocli.CommandLine;

@CommandLine.Command(name="build", description={"Ballerina build - Build Ballerina module(s) and generate executable output."})
public class BuildCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private Path projectPath;
    private boolean exitWhenFinish;
    private boolean skipCopyLibsFromDist;
    @CommandLine.Option(names={"--compile", "-c"}, description={"Compile the source without generating executable(s)."})
    private boolean compile;
    @CommandLine.Option(names={"--output", "-o"}, description={"Write the output to the given file. The provided output file name may or may not contain the '.jar' extension."})
    private String output;
    @CommandLine.Option(names={"--offline"}, description={"Build/Compile offline without downloading dependencies."})
    private Boolean offline;
    @CommandLine.Option(names={"--skip-tests"}, description={"Skip test compilation and execution."})
    private Boolean skipTests;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private Boolean experimentalFlag;
    @CommandLine.Option(names={"--debug"}, description={"run tests in remote debugging mode"})
    private String debugPort;
    private static final String buildCmd = "ballerina build [-o <output>] [--offline] [--skip-tests]\n                    [<ballerina-file | ballerina-project>] [(--key=value)...]";
    @CommandLine.Option(names={"--test-report"}, description={"enable test report generation"})
    private Boolean testReport;
    @CommandLine.Option(names={"--code-coverage"}, description={"enable code coverage"})
    private Boolean coverage;
    @CommandLine.Option(names={"--observability-included"}, description={"package observability in the executable JAR file(s)."})
    private Boolean observabilityIncluded;

    public BuildCommand() {
        this.projectPath = Paths.get(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
        this.skipCopyLibsFromDist = false;
    }

    public BuildCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, boolean skipCopyLibsFromDist) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.skipCopyLibsFromDist = skipCopyLibsFromDist;
    }

    public BuildCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, boolean skipCopyLibsFromDist, Boolean skipTests, Boolean testReport) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.skipCopyLibsFromDist = skipCopyLibsFromDist;
        this.skipTests = skipTests;
        this.testReport = testReport;
    }

    public BuildCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, boolean skipCopyLibsFromDist, String output) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.skipCopyLibsFromDist = skipCopyLibsFromDist;
        this.output = output;
    }

    public void execute() {
        SingleFileProject project;
        String[] args;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"build");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (this.argList == null) {
            args = new String[]{};
            this.projectPath = Paths.get(System.getProperty("user.dir"), new String[0]);
        } else if (this.argList.get(0).startsWith("--")) {
            args = this.argList.toArray(new String[0]);
            this.projectPath = Paths.get(System.getProperty("user.dir"), new String[0]);
        } else {
            args = this.argList.subList(1, this.argList.size()).toArray(new String[0]);
            this.projectPath = Paths.get(this.argList.get(0), new String[0]);
        }
        String[] userArgs = LaunchUtils.getUserArgs((String[])args, new HashMap());
        if (userArgs.length > 0) {
            CommandUtil.printError(this.errStream, "too many arguments.", buildCmd, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (FileUtils.hasExtension(this.projectPath)) {
            if (this.coverage != null && this.coverage.booleanValue()) {
                this.outStream.println("Code coverage is not yet supported with single bal files. Ignoring the flag and continuing the test run...");
            }
            this.coverage = false;
        }
        BuildOptions buildOptions = this.constructBuildOptions();
        boolean isSingleFileBuild = false;
        if (FileUtils.hasExtension(this.projectPath)) {
            if (this.compile) {
                CommandUtil.printError(this.errStream, "'-c' or '--compile' can only be used with modules.", null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            try {
                project = SingleFileProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            isSingleFileBuild = true;
        } else {
            if (null != this.output) {
                CommandUtil.printError(this.errStream, "'-o' and '--output' are only supported when building a single Ballerina file.", "ballerina build -o <output-file> <ballerina-file> ", true);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            try {
                project = BuildProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
        }
        if (!project.buildOptions().skipTests() && this.debugPort != null) {
            System.setProperty("debug", this.debugPort);
        }
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetDirTask(), isSingleFileBuild).addTask(new CreateTargetDirTask()).addTask(new CompileTask(this.outStream, this.errStream)).addTask(new CreateBaloTask(this.outStream), isSingleFileBuild).addTask(new RunTestsTask(this.outStream, this.errStream, args), project.buildOptions().skipTests() || isSingleFileBuild).addTask(new CreateExecutableTask(this.outStream, this.output), this.compile).addTask(new CleanTargetDirTask(), !isSingleFileBuild).build();
        taskExecutor.executeTasks((Project)project);
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    private BuildOptions constructBuildOptions() {
        return new BuildOptionsBuilder().codeCoverage(this.coverage).experimental(this.experimentalFlag).offline(this.offline).skipTests(this.skipTests).testReport(this.testReport).observabilityIncluded(this.observabilityIncluded).build();
    }

    public String getName() {
        return "build";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Build a Ballerina project and produce an executable JAR file. The \n");
        out.append("executable \".jar\" file will be created in the <PROJECT-ROOT>/target/bin directory. \n");
        out.append("\n");
        out.append("Build a single Ballerina file. This creates an executable .jar file in the \n");
        out.append("current directory. The name of the executable file will be \n");
        out.append("<ballerina-file-name>.jar. \n");
        out.append("\n");
        out.append("If the output file is specified with the -o flag, the output \n");
        out.append("will be written to the given output file name. The -o flag will only \n");
        out.append("work for single files. \n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina build [-o <output-file>] [--offline] [--skip-tests] [--skip-lock] {<ballerina-file | module-name> | -a | --all} [--] [(--key=value)...]\n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

