/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.TaskExecutor;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.task.CleanTargetDirTask;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.directory.BuildProject;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.tool.BLauncherCmd;
import picocli.CommandLine;

@CommandLine.Command(name="clean", description={"Ballerina clean - Cleans out the target directory of a project."})
public class CleanCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final Path projectPath;
    private boolean exitWhenFinish;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;

    public CleanCommand(Path projectPath, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.outStream = System.out;
        this.exitWhenFinish = exitWhenFinish;
    }

    public CleanCommand() {
        this.projectPath = Paths.get(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.out;
        this.exitWhenFinish = true;
    }

    public void execute() {
        BuildProject project;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"clean");
            this.outStream.println(commandUsageInfo);
            return;
        }
        try {
            project = BuildProject.load((Path)this.projectPath);
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.outStream, e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetDirTask()).build();
        taskExecutor.executeTasks((Project)project);
    }

    public String getName() {
        return "clean";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Cleans the \"target\" directory of a Ballerina project. \n");
    }

    public void printUsage(StringBuilder out) {
        out.append(" ballerina clean \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

