/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.projects.Package;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.compiler.BLangCompilerException;
import org.wso2.ballerinalang.util.RepoUtils;

public class CommandUtil {
    public static final String ORG_NAME = "ORG_NAME";
    public static final String PKG_NAME = "PKG_NAME";
    public static final String GITIGNORE = "gitignore";
    public static final String NEW_CMD_DEFAULTS = "new_cmd_defaults";
    public static final String CREATE_CMD_TEMPLATES = "create_cmd_templates";
    public static final String PACKAGE_MD_DEFAULTS = "package_md_defaults";
    private static FileSystem jarFs;
    private static Map<String, String> env;

    public static void initJarFs() {
        URI uri = null;
        try {
            uri = CommandUtil.class.getClassLoader().getResource(CREATE_CMD_TEMPLATES).toURI();
            if (uri.toString().contains("!")) {
                String[] array = uri.toString().split("!");
                if (null == jarFs) {
                    env = new HashMap<String, String>();
                    jarFs = FileSystems.newFileSystem(URI.create(array[0]), env);
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new AssertionError();
        }
    }

    public static void printError(PrintStream stream, String error, String usage, boolean help) {
        stream.println("ballerina: " + error);
        if (null != usage) {
            stream.println();
            stream.println("USAGE:");
            stream.println("    " + usage);
        }
        if (help) {
            stream.println();
            stream.println("For more information try --help");
        }
    }

    public static void exitError(boolean exit) {
        if (exit) {
            Runtime.getRuntime().exit(1);
        }
    }

    public static void initProjectByTemplate(Path path, String packageName, String template) throws IOException, URISyntaxException {
        String templateMD = template + "_template.md";
        CommandUtil.initProject(path, packageName);
        CommandUtil.applyTemplate(path, template);
        if (template.equalsIgnoreCase("lib")) {
            Path source = path.resolve("lib.bal");
            Files.move(source, source.resolveSibling(ProjectUtils.guessPkgName((String)packageName) + ".bal"), StandardCopyOption.REPLACE_EXISTING);
        }
        Path gitignore = path.resolve(".gitignore");
        Path packageMD = path.resolve("Package.md");
        Files.createFile(gitignore, new FileAttribute[0]);
        Files.createFile(packageMD, new FileAttribute[0]);
        String defaultGitignore = FileUtils.readFileAsString((String)"new_cmd_defaults/gitignore");
        String defaultPackageMD = FileUtils.readFileAsString((String)("package_md_defaults/" + templateMD));
        Files.write(gitignore, defaultGitignore.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(packageMD, defaultPackageMD.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static List<String> getTemplates() {
        try {
            Path templateDir = CommandUtil.getTemplatePath();
            Stream<Path> walk = Files.walk(templateDir, 1, new FileVisitOption[0]);
            List<String> templates = walk.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(directory -> !templateDir.equals(directory)).filter(directory -> directory.getFileName() != null).map(directory -> directory.getFileName()).map(fileName -> fileName.toString()).collect(Collectors.toList());
            if (null != jarFs) {
                return templates.stream().map(t -> t.replace(jarFs.getSeparator(), "")).collect(Collectors.toList());
            }
            return templates;
        }
        catch (IOException | URISyntaxException e) {
            return new ArrayList<String>();
        }
    }

    private static Path getTemplatePath() throws URISyntaxException {
        URI uri = CommandUtil.class.getClassLoader().getResource(CREATE_CMD_TEMPLATES).toURI();
        if (uri.toString().contains("!")) {
            String[] array = uri.toString().split("!");
            return jarFs.getPath(array[1], new String[0]);
        }
        return Paths.get(uri);
    }

    public static void applyTemplate(Path modulePath, String template) throws IOException, URISyntaxException {
        Path templateDir = CommandUtil.getTemplatePath().resolve(template);
        Files.walkFileTree(templateDir, (FileVisitor<? super Path>)new FileUtils.Copy(templateDir, modulePath));
    }

    public static void initProject(Path path, String packageName) throws IOException {
        Path ballerinaToml = path.resolve("Ballerina.toml");
        Files.createFile(ballerinaToml, new FileAttribute[0]);
        String defaultManifest = FileUtils.readFileAsString((String)"new_cmd_defaults/manifest.toml");
        defaultManifest = defaultManifest.replaceAll(ORG_NAME, ProjectUtils.guessOrgName()).replaceAll(PKG_NAME, ProjectUtils.guessPkgName((String)packageName));
        Files.write(ballerinaToml, defaultManifest.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static Path getJarPathFromHomeCache(Package pkg) {
        try {
            Path packageJarCacheDir = Files.createDirectories(CommandUtil.getJarCacheFromHome().resolve(pkg.packageOrg().toString()).resolve(pkg.packageName().toString()).resolve(pkg.packageVersion().toString()), new FileAttribute[0]);
            return packageJarCacheDir.resolve(ProjectUtils.getJarFileName((Package)pkg) + ".jar");
        }
        catch (IOException e) {
            throw new BLangCompilerException("error resolving bir_cache dir for package: " + pkg.packageName());
        }
    }

    public static Path getJarCacheFromHome() {
        return RepoUtils.createAndGetHomeReposPath().resolve("jar_cache-" + RepoUtils.getBallerinaVersion());
    }
}

