/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.TaskExecutor;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.task.CompileTask;
import io.ballerina.cli.task.CreateDocsTask;
import io.ballerina.cli.task.CreateTargetDirTask;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.BuildOptionsBuilder;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.directory.BuildProject;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.docgen.docs.BallerinaDocGenerator;
import org.ballerinalang.tool.BLauncherCmd;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import picocli.CommandLine;

@CommandLine.Command(name="doc", description={"Ballerina doc - Generates API Documentation"})
public class DocCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private Path projectPath = Paths.get(System.getProperty("user.dir"), new String[0]);
    private Path outputPath;
    private boolean exitWhenFinish;
    @CommandLine.Option(names={"--o", "-o"}, description={"Location to save API Docs."})
    private String outputLoc;
    @CommandLine.Option(names={"--combine", "-combine"}, description={"Creates index using modules."})
    private boolean combine;
    @CommandLine.Option(names={"--offline"}, description={"Compiles offline without downloading dependencies."})
    private boolean offline;
    @CommandLine.Option(names={"--old-parser"}, description={"Enable old parser."}, hidden=true)
    private boolean useOldParser;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--exclude", "-e"}, description={"List of modules to be excluded."})
    private String[] excludes;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private boolean experimentalFlag;

    public DocCommand() {
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
    }

    public DocCommand(PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
    }

    public void execute() {
        BuildProject project;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"doc");
            this.errStream.println(commandUsageInfo);
            return;
        }
        this.projectPath = this.argList == null ? Paths.get(System.getProperty("user.dir"), new String[0]) : Paths.get(this.argList.get(0), new String[0]);
        if (this.combine) {
            this.outStream.println("Combining Docs");
            BallerinaDocGenerator.mergeApiDocs((String)this.projectPath.toString());
            if (this.exitWhenFinish) {
                Runtime.getRuntime().exit(0);
            }
        }
        if (this.argList != null && this.argList.get(0).endsWith(".bal")) {
            CommandUtil.printError(this.errStream, "generating API Documentation is not supported for a single Ballerina file.", null, false);
            CommandUtil.exitError(true);
            return;
        }
        if (this.argList != null && this.argList.size() > 1) {
            CommandUtil.printError(this.errStream, "too many arguments.", "ballerina doc <project_path> [--offline]\n", false);
            CommandUtil.exitError(true);
            return;
        }
        BuildOptions buildOptions = this.constructBuildOptions();
        try {
            project = BuildProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.errStream, e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        this.projectPath = this.projectPath.normalize();
        this.outputPath = this.outputLoc != null ? Paths.get(this.outputLoc, new String[0]).toAbsolutePath() : null;
        CompilerContext compilerContext = (CompilerContext)project.projectEnvironmentContext().getService(CompilerContext.class);
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)compilerContext);
        options.put(CompilerOptionName.COMPILER_PHASE, CompilerPhase.CODE_GEN.toString());
        options.put(CompilerOptionName.OFFLINE, Boolean.toString(this.offline));
        options.put(CompilerOptionName.LOCK_ENABLED, "true");
        options.put(CompilerOptionName.SKIP_TESTS, "true");
        options.put(CompilerOptionName.TEST_ENABLED, "false");
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(this.experimentalFlag));
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, "true");
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CreateTargetDirTask()).addTask(new CompileTask(this.outStream, this.errStream)).addTask(new CreateDocsTask(this.outStream, this.outputPath)).build();
        taskExecutor.executeTasks((Project)project);
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    public String getName() {
        return "doc";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Generates API Documentation for Ballerina projects. \n");
        out.append("\n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina doc \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private BuildOptions constructBuildOptions() {
        return new BuildOptionsBuilder().codeCoverage(Boolean.valueOf(false)).experimental(Boolean.valueOf(this.experimentalFlag)).offline(Boolean.valueOf(this.offline)).skipTests(Boolean.valueOf(true)).testReport(Boolean.valueOf(false)).observabilityIncluded(Boolean.valueOf(false)).build();
    }
}

