/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.tool.BLauncherCmd;
import picocli.CommandLine;

@CommandLine.Command(name="init", description={"Create a Init Ballerina project"})
public class InitCommand
implements BLauncherCmd {
    private Path userDir;
    private PrintStream errStream;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--template", "-t"}, description={"Acceptable values: [main, service, lib]"})
    private String template = "";

    public InitCommand() {
        this.userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        this.errStream = System.err;
        CommandUtil.initJarFs();
    }

    public InitCommand(Path userDir, PrintStream errStream) {
        this.userDir = userDir;
        this.errStream = errStream;
        CommandUtil.initJarFs();
    }

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"init");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (ProjectUtils.isBallerinaProject((Path)this.userDir)) {
            CommandUtil.printError(this.errStream, "Directory is already a ballerina project", null, false);
            return;
        }
        if (this.argList != null && 1 != this.argList.size()) {
            CommandUtil.printError(this.errStream, "too many arguments.", "ballerina init <project-name>", true);
            return;
        }
        Path projectRoot = ProjectUtils.findProjectRoot((Path)this.userDir);
        if (projectRoot != null) {
            CommandUtil.printError(this.errStream, "Directory is already within a ballerina project :" + projectRoot.resolve("Ballerina.toml").toString(), null, false);
            return;
        }
        if (!this.template.equals("") && !CommandUtil.getTemplates().contains(this.template)) {
            CommandUtil.printError(this.errStream, "Template not found, use `ballerina init --help` to view available templates.", null, false);
            return;
        }
        String packageName = Optional.of(this.userDir.getFileName()).get().toString();
        if (this.argList != null && this.argList.size() > 0 && !ProjectUtils.validatePkgName((String)(packageName = this.argList.get(0)))) {
            CommandUtil.printError(this.errStream, "Invalid package name : '" + packageName + "' :\nPackage name can only contain alphanumerics and underscoresand the maximum length is 256 characters", null, false);
            return;
        }
        if (!ProjectUtils.validatePkgName((String)packageName)) {
            this.errStream.println("Unallowed characters in the project name were replaced by underscores when deriving the package name. Edit the Ballerina.toml to change it.");
            this.errStream.println();
        }
        try {
            if (this.template.equals("")) {
                CommandUtil.initProject(this.userDir, packageName);
            } else {
                CommandUtil.initProjectByTemplate(this.userDir, packageName, this.template);
            }
        }
        catch (AccessDeniedException e) {
            this.errStream.println("error: Error occurred while initializing project :  Access Denied : " + e.getMessage());
            return;
        }
        catch (IOException | URISyntaxException e) {
            this.errStream.println("error: Error occurred while initializing project : " + e.getMessage());
            return;
        }
        this.errStream.println("Ballerina project initialised ");
        this.errStream.println();
    }

    public String getName() {
        return "init";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("initialize a ballerina project in current directory");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina init \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

