/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.utils.CentralUtils;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.regex.Pattern;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.exceptions.PackageAlreadyExistsException;
import org.ballerinalang.toml.model.Proxy;
import org.ballerinalang.toml.model.Settings;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.programfile.ProgramFileConstants;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="pull", description={"download the module source and binaries from a remote repository"})
public class PullCommand
implements BLauncherCmd {
    private PrintStream errStream;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--debug"}, hidden=true)
    private String debugPort;

    public PullCommand() {
        this.errStream = System.err;
    }

    public PullCommand(PrintStream errStream) {
        this.errStream = errStream;
    }

    public void execute() {
        String version;
        String packageName;
        String resourceName;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"pull");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (this.argList == null || this.argList.isEmpty()) {
            CommandUtil.printError(this.errStream, "no package given", "ballerina pull <package-name> ", false);
            return;
        }
        if (this.argList.size() > 1) {
            CommandUtil.printError(this.errStream, "too many arguments", "ballerina pull <package-name> ", false);
            return;
        }
        if (null != this.debugPort) {
            System.setProperty("debug", this.debugPort);
        }
        if (!this.validPackageName(resourceName = this.argList.get(0))) {
            CommandUtil.printError(this.errStream, "invalid package name. Provide the package name with the org name ", "ballerina pull {<org-name>/<package-name> | <org-name>/<package-name>:<version>}", false);
            return;
        }
        String[] moduleInfo = resourceName.split("/");
        String orgName = moduleInfo[0];
        String moduleNameAndVersion = moduleInfo[1];
        String[] packageInfo = moduleNameAndVersion.split(":");
        if (packageInfo.length == 2) {
            packageName = packageInfo[0];
            version = packageInfo[1];
        } else {
            packageName = moduleNameAndVersion;
            version = Names.EMPTY.getValue();
        }
        Path packagePathInBaloCache = ProjectUtils.createAndGetHomeReposPath().resolve("balo_cache").resolve(orgName).resolve(packageName);
        try {
            Files.createDirectories(packagePathInBaloCache, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)("unexpected error occurred while creating package repository in balo cache: " + e.getMessage()));
        }
        for (String supportedPlatform : ProgramFileConstants.SUPPORTED_PLATFORMS) {
            try {
                Settings settings = CentralUtils.readSettings();
                java.net.Proxy proxy = ProjectUtils.initializeProxy((Proxy)settings.getProxy());
                CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), proxy);
                client.pullPackage(orgName, packageName, version, packagePathInBaloCache, supportedPlatform, RepoUtils.getBallerinaVersion(), false);
            }
            catch (PackageAlreadyExistsException e) {
                this.errStream.println(e.getMessage());
                Runtime.getRuntime().exit(0);
            }
            catch (CentralClientException e) {
                this.errStream.println("unexpected error occurred while pulling package:" + e.getMessage());
                Runtime.getRuntime().exit(1);
            }
        }
        Runtime.getRuntime().exit(0);
    }

    public String getName() {
        return "pull";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("download modules to the user repository \n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina pull\n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private String getPullCommandRegex() {
        return "[^0-9_][_\\w]+/[^0-9_][_\\.\\w]+|[^0-9_][_\\w]+/[^0-9_][_\\.\\w]+:[*\\d]+|[^0-9_][_\\w]+/[^0-9_][_\\.\\w]+:[*\\d]+\\.[*\\d]+|[^0-9_][_\\w]+/[^0-9_][_\\.\\w]+:[*\\d]+\\.[*\\d]+\\.[*\\d]+";
    }

    private boolean validPackageName(String str) {
        return Pattern.matches(this.getPullCommandRegex(), str);
    }
}

