/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.utils.CentralUtils;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.balo.BaloProject;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.repos.TempDirCompilationCache;
import io.ballerina.projects.util.ProjectUtils;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.exceptions.NoPackageException;
import org.ballerinalang.toml.model.Proxy;
import org.ballerinalang.toml.model.Settings;
import org.ballerinalang.tool.BLauncherCmd;
import org.wso2.ballerinalang.programfile.ProgramFileConstants;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="push", description={"push packages and binaries available locally to Ballerina Central"})
public class PushCommand
implements BLauncherCmd {
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--debug"}, hidden=true)
    private String debugPort;
    @CommandLine.Option(names={"--repository"}, hidden=true)
    private String repositoryHome;
    @CommandLine.Option(names={"--skip-source-check"}, description={"skip checking if source has changed"})
    private boolean skipSourceCheck;
    @CommandLine.Option(names={"--experimental"}, description={"enable experimental language features"})
    private boolean experimentalFlag;
    private Path userDir;
    private PrintStream errStream;
    private PrintStream outStream;

    public PushCommand() {
        this.userDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        this.errStream = System.err;
        this.outStream = System.out;
    }

    public PushCommand(Path userDir, PrintStream outStream, PrintStream errStream) {
        this.userDir = userDir;
        this.outStream = outStream;
        this.errStream = errStream;
    }

    public void execute() {
        BuildProject project;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"push");
            this.outStream.println(commandUsageInfo);
            return;
        }
        try {
            project = BuildProject.load((Path)this.userDir);
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.errStream, e.getMessage(), null, false);
            return;
        }
        if (null != this.debugPort) {
            System.setProperty("debug", this.debugPort);
        }
        if (this.argList == null || this.argList.isEmpty()) {
            Settings settings = CentralUtils.readSettings();
            java.net.Proxy proxy = ProjectUtils.initializeProxy((Proxy)settings.getProxy());
            CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), proxy);
            try {
                this.pushPackage(project, client, settings);
            }
            catch (ProjectException | CentralClientException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), null, false);
                return;
            }
        } else {
            CommandUtil.printError(this.errStream, "too many arguments", "ballerina push ", false);
            return;
        }
        Runtime.getRuntime().exit(0);
    }

    public String getName() {
        return "push";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("push packages to Ballerina Central");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina push \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private void pushPackage(BuildProject project, CentralAPIClient client, Settings settings) throws CentralClientException {
        Path baloFilePath = PushCommand.validateBalo(project, client);
        this.pushBaloToRemote(baloFilePath, client, settings);
    }

    private static Path validateBalo(BuildProject project, CentralAPIClient client) throws CentralClientException {
        PackageName pkgName = project.currentPackage().packageName();
        PackageOrg orgName = project.currentPackage().packageOrg();
        PackageVersion version = project.currentPackage().packageVersion();
        Path baloOutputDir = project.currentPackage().project().sourceRoot().resolve("target").resolve("balo");
        if (Files.notExists(baloOutputDir, new LinkOption[0])) {
            throw new ProjectException("cannot find balo file for the package: " + pkgName + ". Run 'ballerina build' to compile and generate the balo.");
        }
        Path packageBaloFile = PushCommand.findBaloFile(pkgName, orgName, baloOutputDir);
        if (null == packageBaloFile) {
            throw new ProjectException("cannot find balo file for the package: " + pkgName + ". Run 'ballerina build' to compile and generate the balo.");
        }
        PackageManifest.Dependency pkgAsDependency = new PackageManifest.Dependency(pkgName, orgName, version);
        if (PushCommand.isPackageAvailableInRemote(pkgAsDependency, client)) {
            String pkg = pkgAsDependency.org().toString() + "/" + pkgAsDependency.name().toString() + ":" + pkgAsDependency.version().toString();
            throw new ProjectException("package '" + pkg + "' already exists in remote repository(" + RepoUtils.getRemoteRepoURL() + "). build and push after updating the version in the Ballerina.toml.");
        }
        return packageBaloFile;
    }

    private void pushBaloToRemote(Path baloPath, CentralAPIClient client, Settings settings) {
        block5: {
            Path baloFileName = baloPath.getFileName();
            if (null != baloFileName) {
                ProjectEnvironmentBuilder defaultBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
                defaultBuilder.addCompilationCacheFactory(TempDirCompilationCache::from);
                BaloProject baloProject = BaloProject.loadProject((ProjectEnvironmentBuilder)defaultBuilder, (Path)baloPath);
                String org = baloProject.currentPackage().manifest().org().toString();
                String name = baloProject.currentPackage().manifest().name().toString();
                String version = baloProject.currentPackage().manifest().version().toString();
                Path ballerinaHomePath = RepoUtils.createAndGetHomeReposPath();
                Path settingsTomlFilePath = ballerinaHomePath.resolve("Settings.toml");
                String accessToken = CentralUtils.authenticate(this.errStream, CentralUtils.getBallerinaCentralCliTokenUrl(), settings, settingsTomlFilePath);
                try {
                    client.pushPackage(baloPath, org, name, version, accessToken);
                }
                catch (CentralClientException e) {
                    String errorMessage = e.getMessage();
                    if (null == errorMessage || "".equals(errorMessage.trim())) break block5;
                    if (errorMessage.contains("\n\tat")) {
                        errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n\tat"));
                    }
                    if ((errorMessage = errorMessage.replaceAll("error: ", "")).contains("subject claims missing in the user info repsonse")) {
                        errorMessage = "invalid access token in the 'Settings.toml'";
                    }
                    throw new ProjectException(errorMessage);
                }
            }
        }
    }

    private static boolean isPackageAvailableInRemote(PackageManifest.Dependency pkg, CentralAPIClient client) throws CentralClientException {
        List supportedPlatforms = Arrays.stream(ProgramFileConstants.SUPPORTED_PLATFORMS).collect(Collectors.toList());
        supportedPlatforms.add("any");
        Iterator iterator = supportedPlatforms.iterator();
        if (iterator.hasNext()) {
            String supportedPlatform = (String)iterator.next();
            try {
                client.getPackage(pkg.org().toString(), pkg.name().toString(), pkg.version().toString(), supportedPlatform);
                return true;
            }
            catch (NoPackageException e) {
                return false;
            }
        }
        return false;
    }

    private static Path findBaloFile(PackageName pkgName, PackageOrg orgName, Path baloOutputDir) {
        Path baloFilePath = null;
        File[] baloFiles = new File(baloOutputDir.toString()).listFiles();
        if (baloFiles != null && baloFiles.length > 0) {
            for (File baloFile : baloFiles) {
                if (baloFile == null || !baloFile.getName().startsWith(orgName + "-" + pkgName)) continue;
                baloFilePath = baloFile.toPath();
                break;
            }
        }
        return baloFilePath;
    }
}

