/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.TaskExecutor;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.task.CleanTargetDirTask;
import io.ballerina.cli.task.CompileTask;
import io.ballerina.cli.task.CreateBaloTask;
import io.ballerina.cli.task.CreateTargetDirTask;
import io.ballerina.cli.task.RunExecutableTask;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.BuildOptionsBuilder;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.SingleFileProject;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.ballerinalang.tool.BLauncherCmd;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Build and execute a Ballerina program."})
public class RunCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private Path projectPath;
    private boolean exitWhenFinish;
    @CommandLine.Parameters(description={"Program arguments"})
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--offline"}, description={"Builds offline without downloading dependencies and then run."})
    private boolean offline;
    @CommandLine.Option(names={"--debug"}, hidden=true)
    private String debugPort;
    @CommandLine.Option(names={"--dump-bir"}, hidden=true)
    private boolean dumpBIR;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private boolean experimentalFlag;
    @CommandLine.Option(names={"--observability-included"}, description={"package observability in the executable when run is used with a source file or a module."})
    private Boolean observabilityIncluded;
    private static final String runCmd = "ballerina run {<ballerina-file | project-name> | <executable-jar>} [--] [(--key=value)...]";

    public RunCommand() {
        this.outStream = System.err;
        this.errStream = System.err;
    }

    public RunCommand(Path projectPath, PrintStream outStream, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.exitWhenFinish = exitWhenFinish;
        this.outStream = outStream;
        this.errStream = outStream;
    }

    public void execute() {
        SingleFileProject project;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"run");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (this.debugPort != null) {
            System.setProperty("debug", this.debugPort);
        }
        if (this.argList == null) {
            CommandUtil.printError(this.errStream, "no project path provided.", runCmd, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String[] args = this.argList.subList(1, this.argList.size()).toArray(new String[0]);
        this.projectPath = Paths.get(this.argList.get(0), new String[0]).toAbsolutePath().normalize();
        BuildOptions buildOptions = this.constructBuildOptions();
        boolean isSingleFileBuild = false;
        if (FileUtils.hasExtension(this.projectPath)) {
            try {
                project = SingleFileProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            isSingleFileBuild = true;
        } else {
            try {
                project = BuildProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
        }
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetDirTask(), isSingleFileBuild).addTask(new CreateTargetDirTask()).addTask(new CompileTask(this.outStream, this.errStream)).addTask(new CreateBaloTask(this.outStream), isSingleFileBuild).addTask(new RunExecutableTask(args, this.outStream, this.errStream)).build();
        taskExecutor.executeTasks((Project)project);
    }

    public String getName() {
        return "run";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Run command runs a compiled Ballerina program. \n");
        out.append("\n");
        out.append("If a Ballerina source file is given, \n");
        out.append("run command compiles and runs it. \n");
        out.append("\n");
        out.append("By default, 'ballerina run' executes the main function. \n");
        out.append("If the main function is not there, it executes services. \n");
        out.append("\n");
    }

    public void printUsage(StringBuilder out) {
        out.append("  ballerina run {<balfile> | <project-path> | executable-jar}[--offline]\n                 [(--key=value)...] [--] [args...] \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private BuildOptions constructBuildOptions() {
        return new BuildOptionsBuilder().codeCoverage(Boolean.valueOf(false)).experimental(Boolean.valueOf(this.experimentalFlag)).offline(Boolean.valueOf(this.offline)).skipTests(Boolean.valueOf(true)).testReport(Boolean.valueOf(false)).observabilityIncluded(this.observabilityIncluded).build();
    }
}

