/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.utils.CentralUtils;
import io.ballerina.cli.utils.PrintUtils;
import io.ballerina.projects.util.ProjectUtils;
import java.io.PrintStream;
import java.util.List;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.model.PackageSearchResult;
import org.ballerinalang.toml.model.Proxy;
import org.ballerinalang.toml.model.Settings;
import org.ballerinalang.tool.BLauncherCmd;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="search", description={"search for packages within Ballerina Central"})
public class SearchCommand
implements BLauncherCmd {
    private PrintStream outStream;
    private PrintStream errStream;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--debug"}, hidden=true)
    private String debugPort;

    public SearchCommand() {
        this.outStream = System.out;
        this.errStream = System.err;
    }

    public SearchCommand(PrintStream outStream, PrintStream errStream) {
        this.outStream = outStream;
        this.errStream = errStream;
    }

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"search");
            this.outStream.println(commandUsageInfo);
            return;
        }
        if (null != this.debugPort) {
            System.setProperty("debug", this.debugPort);
        }
        if (this.argList == null || this.argList.isEmpty()) {
            CommandUtil.printError(this.errStream, "no keyword given", "ballerina search [<org>|<package>|<text>] ", false);
            return;
        }
        if (this.argList.size() > 1) {
            CommandUtil.printError(this.errStream, "too many arguments", "ballerina search [<org>|<package>|<text>] ", false);
            return;
        }
        String searchArgs = this.argList.get(0);
        this.searchInCentral(searchArgs);
        Runtime.getRuntime().exit(0);
    }

    public String getName() {
        return "search";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("searches for packages within Ballerina Central \n");
    }

    public void printUsage(StringBuilder out) {
        out.append(" ballerina search [<org>|<package>|<text>] \n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private void searchInCentral(String query) {
        block5: {
            try {
                Settings settings = CentralUtils.readSettings();
                java.net.Proxy proxy = ProjectUtils.initializeProxy((Proxy)settings.getProxy());
                CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), proxy);
                PackageSearchResult packageSearchResult = client.searchPackage(query);
                if (packageSearchResult.getCount() > 0) {
                    PrintUtils.printPackages(packageSearchResult.getPackages(), RepoUtils.getTerminalWidth());
                } else {
                    this.outStream.println("no modules found");
                }
            }
            catch (CentralClientException e) {
                String errorMessage = e.getMessage();
                if (null == errorMessage || "".equals(errorMessage.trim())) break block5;
                if (errorMessage.contains("\n\tat")) {
                    errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n\tat"));
                }
                CommandUtil.printError(this.errStream, errorMessage, null, false);
            }
        }
    }
}

