/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.TaskExecutor;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.task.CleanTargetDirTask;
import io.ballerina.cli.task.CompileTask;
import io.ballerina.cli.task.CreateBaloTask;
import io.ballerina.cli.task.CreateTargetDirTask;
import io.ballerina.cli.task.ListTestGroupsTask;
import io.ballerina.cli.task.RunTestsTask;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.BuildOptionsBuilder;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.SingleFileProject;
import io.ballerina.runtime.internal.launch.LaunchUtils;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import org.ballerinalang.tool.BLauncherCmd;
import picocli.CommandLine;

@CommandLine.Command(name="test", description={"Test Ballerina modules"})
public class TestCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private Path projectPath;
    private boolean exitWhenFinish;
    @CommandLine.Option(names={"--offline"}, description={"Builds/Compiles offline without downloading dependencies."})
    private Boolean offline;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private Boolean experimentalFlag;
    @CommandLine.Option(names={"--debug"}, description={"start in remote debugging mode"})
    private String debugPort;
    @CommandLine.Option(names={"--list-groups"}, description={"list the groups available in the tests"})
    private boolean listGroups;
    @CommandLine.Option(names={"--groups"}, split=",", description={"test groups to be executed"})
    private List<String> groupList;
    @CommandLine.Option(names={"--disable-groups"}, split=",", description={"test groups to be disabled"})
    private List<String> disableGroupList;
    @CommandLine.Option(names={"--test-report"}, description={"enable test report generation"})
    private Boolean testReport;
    @CommandLine.Option(names={"--code-coverage"}, description={"enable code coverage"})
    private Boolean coverage;
    @CommandLine.Option(names={"--observability-included"}, description={"package observability in the executable."})
    private Boolean observabilityIncluded;
    @CommandLine.Option(names={"--tests"}, split=",", description={"Test functions to be executed"})
    private List<String> testList;
    @CommandLine.Option(names={"--rerun-failed"}, description={"Rerun failed tests."})
    private boolean rerunTests;
    private static final String testCmd = "ballerina test [--offline] [--skip-tests]\n                    [<ballerina-file> | <ballerina-project>] [(--key=value)...]";

    public TestCommand() {
        this.projectPath = Paths.get(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
    }

    public TestCommand(Path projectPath, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = exitWhenFinish;
    }

    public TestCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
    }

    public void execute() {
        SingleFileProject project;
        String[] args;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)"test");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (this.argList == null) {
            args = new String[]{};
            this.projectPath = Paths.get(System.getProperty("user.dir"), new String[0]);
        } else if (this.argList.get(0).startsWith("--")) {
            args = this.argList.toArray(new String[0]);
            this.projectPath = Paths.get(System.getProperty("user.dir"), new String[0]);
        } else {
            args = this.argList.subList(1, this.argList.size()).toArray(new String[0]);
            this.projectPath = Paths.get(this.argList.get(0), new String[0]);
        }
        String[] userArgs = LaunchUtils.getUserArgs((String[])args, new HashMap());
        if (userArgs.length > 0) {
            CommandUtil.printError(this.errStream, "too many arguments.", testCmd, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (FileUtils.hasExtension(this.projectPath)) {
            if (this.coverage != null && this.coverage.booleanValue()) {
                this.outStream.println("Code coverage is not yet supported with single bal files. Ignoring the flag and continuing the test run...");
            }
            this.coverage = false;
        }
        BuildOptions buildOptions = this.constructBuildOptions();
        boolean isSingleFile = false;
        if (FileUtils.hasExtension(this.projectPath)) {
            try {
                project = SingleFileProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            isSingleFile = true;
        } else {
            try {
                project = BuildProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
        }
        if (this.debugPort != null) {
            System.setProperty("debug", this.debugPort);
        }
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetDirTask(), isSingleFile).addTask(new CreateTargetDirTask()).addTask(new CompileTask(this.outStream, this.errStream)).addTask(new CreateBaloTask(this.outStream), isSingleFile || this.listGroups).addTask(new ListTestGroupsTask(this.outStream), !this.listGroups).addTask(new RunTestsTask(this.outStream, this.errStream, args, this.rerunTests, this.groupList, this.disableGroupList, this.testList), this.listGroups).build();
        taskExecutor.executeTasks((Project)project);
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    private BuildOptions constructBuildOptions() {
        return new BuildOptionsBuilder().codeCoverage(this.coverage).experimental(this.experimentalFlag).offline(this.offline).skipTests(Boolean.valueOf(false)).testReport(this.testReport).observabilityIncluded(this.observabilityIncluded).build();
    }

    public String getName() {
        return "test";
    }

    public void printLongDesc(StringBuilder out) {
        out.append("Test a Ballerina project or a standalone Ballerina file. \n");
    }

    public void printUsage(StringBuilder out) {
        out.append("ballerina test [--offline] [--skip-tests]\n                    [<ballerina-file> | <ballerina-project>] [(--key=value)...]\n");
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

