/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.task.Task;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JdkVersion;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.directory.SingleFileProject;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.io.PrintStream;
import org.ballerinalang.tool.LauncherUtils;

public class CompileTask
implements Task {
    private final transient PrintStream out;
    private final transient PrintStream err;

    public CompileTask(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    @Override
    public void execute(Project project) {
        this.out.println();
        this.out.println("Compiling source");
        Object sourceName = project instanceof SingleFileProject ? project.currentPackage().getDefaultModule().document((DocumentId)project.currentPackage().getDefaultModule().documentIds().iterator().next()).name() : project.currentPackage().packageOrg().toString() + "/" + project.currentPackage().packageName().toString() + ":" + project.currentPackage().packageVersion();
        this.out.println("\t" + (String)sourceName);
        try {
            PackageCompilation packageCompilation = project.currentPackage().getCompilation();
            JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)packageCompilation, (JdkVersion)JdkVersion.JAVA_11);
            DiagnosticResult diagnosticResult = jBallerinaBackend.diagnosticResult();
            diagnosticResult.diagnostics().forEach(d -> this.err.println(this.convertDiagnosticToString((Diagnostic)d)));
            if (diagnosticResult.hasErrors()) {
                throw LauncherUtils.createLauncherException((String)"compilation contains errors");
            }
        }
        catch (ProjectException e) {
            throw LauncherUtils.createLauncherException((String)("compilation failed: " + e.getMessage()));
        }
    }

    private String convertDiagnosticToString(Diagnostic diagnostic) {
        LineRange lineRange = diagnostic.location().lineRange();
        LineRange oneBasedLineRange = LineRange.from((String)lineRange.filePath(), (LinePosition)LinePosition.from((int)(lineRange.startLine().line() + 1), (int)(lineRange.startLine().offset() + 1)), (LinePosition)LinePosition.from((int)(lineRange.endLine().line() + 1), (int)(lineRange.endLine().offset() + 1)));
        return diagnostic.diagnosticInfo().severity().toString() + " [" + oneBasedLineRange.filePath() + ":" + oneBasedLineRange + "] " + diagnostic.message();
    }
}

