/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.task.Task;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JdkVersion;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.internal.model.Target;
import io.ballerina.projects.util.ProjectUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import org.ballerinalang.tool.LauncherUtils;

public class CreateBaloTask
implements Task {
    private final transient PrintStream out;

    public CreateBaloTask(PrintStream out) {
        this.out = out;
    }

    @Override
    public void execute(Project project) {
        Path baloPath;
        this.out.println();
        this.out.println("Creating balos");
        try {
            Target target = new Target(project.sourceRoot());
            baloPath = target.getBaloPath();
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)e.getMessage());
        }
        String baloName = ProjectUtils.getBaloName((String)project.currentPackage().packageOrg().toString(), (String)project.currentPackage().packageName().toString(), (String)project.currentPackage().packageVersion().toString(), null);
        try {
            PackageCompilation packageCompilation = project.currentPackage().getCompilation();
            JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)packageCompilation, (JdkVersion)JdkVersion.JAVA_11);
            jBallerinaBackend.emit(JBallerinaBackend.OutputType.BALO, baloPath.resolve(baloName));
        }
        catch (ProjectException e) {
            throw LauncherUtils.createLauncherException((String)("BALO creation failed:" + e.getMessage()));
        }
        Path relativePathToExecutable = project.sourceRoot().relativize(baloPath.resolve(baloName));
        if (relativePathToExecutable.toString().contains("..") || relativePathToExecutable.toString().contains("." + File.separator)) {
            this.out.println("\t" + baloPath.resolve(baloName).toString());
        } else {
            this.out.println("\t" + relativePathToExecutable.toString());
        }
    }
}

