/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.task.Task;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JdkVersion;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.internal.model.Target;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ServiceLoader;
import org.ballerinalang.compiler.plugins.CompilerPlugin;
import org.ballerinalang.tool.LauncherUtils;

public class CreateExecutableTask
implements Task {
    private final transient PrintStream out;
    private Path output;

    public CreateExecutableTask(PrintStream out, String output) {
        this.out = out;
        if (output != null) {
            this.output = Paths.get(output, new String[0]);
        }
    }

    @Override
    public void execute(Project project) {
        Path executablePath;
        Target target;
        this.out.println();
        this.out.println("Generating executable");
        Path currentDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        try {
            target = new Target(project.sourceRoot());
            if (project.kind() == ProjectKind.SINGLE_FILE_PROJECT) {
                Path outputPath;
                DocumentId documentId = (DocumentId)project.currentPackage().getDefaultModule().documentIds().iterator().next();
                String documentName = project.currentPackage().getDefaultModule().document(documentId).name();
                String executableName = FileUtils.geFileNameWithoutExtension(Paths.get(documentName, new String[0]));
                if (executableName == null) {
                    throw LauncherUtils.createLauncherException((String)"unable to determine executable name");
                }
                if (this.output != null) {
                    outputPath = Files.isDirectory(this.output, new LinkOption[0]) ? this.output.resolve(executableName + ".jar") : (!FileUtils.hasExtension(this.output) ? Paths.get(this.output.toString() + ".jar", new String[0]) : this.output);
                    if (!outputPath.isAbsolute()) {
                        outputPath = currentDir.resolve(outputPath);
                    }
                } else {
                    outputPath = currentDir.resolve(executableName + ".jar");
                }
                target.setOutputPath(outputPath);
            }
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)("unable to set executable path: " + e.getMessage()));
        }
        try {
            executablePath = target.getExecutablePath(project.currentPackage()).toAbsolutePath().normalize();
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)e.getMessage());
        }
        try {
            PackageCompilation pkgCompilation = project.currentPackage().getCompilation();
            JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)pkgCompilation, (JdkVersion)JdkVersion.JAVA_11);
            jBallerinaBackend.emit(JBallerinaBackend.OutputType.EXEC, executablePath);
        }
        catch (ProjectException e) {
            throw LauncherUtils.createLauncherException((String)e.getMessage());
        }
        this.notifyPlugins(project, target);
        Path relativePathToExecutable = currentDir.relativize(executablePath);
        if (relativePathToExecutable.toString().contains("..") || relativePathToExecutable.toString().contains("." + File.separator)) {
            this.out.println("\t" + executablePath.toString());
        } else {
            this.out.println("\t" + relativePathToExecutable.toString());
        }
    }

    private void notifyPlugins(Project project, Target target) {
        ServiceLoader<CompilerPlugin> processorServiceLoader = ServiceLoader.load(CompilerPlugin.class);
        for (CompilerPlugin plugin : processorServiceLoader) {
            plugin.codeGenerated(project, target);
        }
    }
}

