/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.task.Task;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JdkVersion;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.testsuite.Test;
import io.ballerina.projects.testsuite.TestSuite;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ListTestGroupsTask
implements Task {
    private final PrintStream out;

    public ListTestGroupsTask(PrintStream out) {
        this.out = out;
    }

    @Override
    public void execute(Project project) {
        for (ModuleId moduleId : project.currentPackage().moduleIds()) {
            Module module = project.currentPackage().module(moduleId);
            PackageCompilation packageCompilation = project.currentPackage().getCompilation();
            JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)packageCompilation, (JdkVersion)JdkVersion.JAVA_11);
            Optional suite = jBallerinaBackend.testSuite(module);
            if (!project.currentPackage().packageOrg().anonymous()) {
                this.out.println();
                this.out.println("\t" + module.moduleName().toString());
            }
            this.listGroups(suite.orElse(null), this.out);
        }
    }

    private void listGroups(TestSuite testSuite, PrintStream outStream) {
        List<String> groupList = this.getGroupList(testSuite);
        if (groupList.size() == 0) {
            outStream.println("\tThere are no groups available!");
        } else {
            outStream.println("\tFollowing groups are available : ");
            outStream.println("\t" + groupList);
        }
    }

    private List<String> getGroupList(TestSuite testSuite) {
        if (testSuite == null) {
            return Collections.emptyList();
        }
        ArrayList groupList = new ArrayList();
        for (Test test : testSuite.getTests()) {
            if (test.getGroups().size() <= 0) continue;
            groupList.addAll(test.getGroups());
        }
        return groupList.stream().distinct().collect(Collectors.toList());
    }
}

