/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.task.Task;
import io.ballerina.cli.utils.DebugUtils;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JarResolver;
import io.ballerina.projects.JdkVersion;
import io.ballerina.projects.Module;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.ballerinalang.tool.LauncherUtils;
import org.ballerinalang.tool.RuntimePanicException;
import org.wso2.ballerinalang.util.Lists;

public class RunExecutableTask
implements Task {
    private final List<String> args;
    private final transient PrintStream out;
    private final transient PrintStream err;

    public RunExecutableTask(String[] args, PrintStream out, PrintStream err) {
        this.args = Lists.of((Object[])args);
        this.out = out;
        this.err = err;
    }

    @Override
    public void execute(Project project) {
        this.out.println();
        this.out.println("Running executable");
        this.out.println();
        this.runGeneratedExecutable(project.currentPackage().getDefaultModule(), project);
    }

    private void runGeneratedExecutable(Module executableModule, Project project) {
        PackageCompilation packageCompilation = project.currentPackage().getCompilation();
        JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)packageCompilation, (JdkVersion)JdkVersion.JAVA_11);
        JarResolver jarResolver = jBallerinaBackend.jarResolver();
        String initClassName = JarResolver.getQualifiedClassName((String)executableModule.packageInstance().packageOrg().toString(), (String)executableModule.packageInstance().packageName().toString(), (String)executableModule.packageInstance().packageVersion().toString(), (String)"$_init");
        try {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("java");
            commands.add("-cp");
            commands.add(this.getAllClassPaths(jarResolver));
            if (DebugUtils.isInDebugMode()) {
                commands.add(DebugUtils.getDebugArgs(this.err));
            }
            commands.add(initClassName);
            commands.addAll(this.args);
            ProcessBuilder pb = new ProcessBuilder(commands).inheritIO();
            Process process = pb.start();
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                throw new RuntimePanicException(exitValue);
            }
        }
        catch (IOException | InterruptedException e) {
            throw LauncherUtils.createLauncherException((String)"Error occurred while running the executable ", (Throwable)e.getCause());
        }
    }

    private String getAllClassPaths(JarResolver jarResolver) {
        StringJoiner cp = new StringJoiner(File.pathSeparator);
        jarResolver.getJarFilePathsRequiredForExecution().stream().map(Path::toString).forEach(cp::add);
        return cp.toString();
    }
}

