/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import com.google.gson.Gson;
import io.ballerina.cli.task.Task;
import io.ballerina.cli.utils.DebugUtils;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JarResolver;
import io.ballerina.projects.JdkVersion;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.internal.model.Target;
import io.ballerina.projects.testsuite.TestSuite;
import io.ballerina.projects.testsuite.TesterinaRegistry;
import io.ballerina.projects.util.ProjectUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import org.ballerinalang.test.runtime.entity.CoverageReport;
import org.ballerinalang.test.runtime.entity.ModuleStatus;
import org.ballerinalang.test.runtime.entity.TestReport;
import org.ballerinalang.test.runtime.util.CodeCoverageUtils;
import org.ballerinalang.test.runtime.util.TesterinaUtils;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.util.Lists;

public class RunTestsTask
implements Task {
    private final PrintStream out;
    private final PrintStream err;
    private final List<String> args;
    private List<String> groupList;
    private List<String> disableGroupList;
    private boolean report;
    private boolean coverage;
    private boolean isSingleTestExecution;
    private boolean isRerunTestExecution;
    private List<String> singleExecTests;
    TestReport testReport;

    public RunTestsTask(PrintStream out, PrintStream err, String[] args) {
        this.out = out;
        this.err = err;
        this.args = Lists.of((Object[])args);
    }

    public RunTestsTask(PrintStream out, PrintStream err, String[] args, boolean rerunTests, List<String> groupList, List<String> disableGroupList, List<String> testList) {
        this.out = out;
        this.err = err;
        this.args = Lists.of((Object[])args);
        this.isSingleTestExecution = false;
        this.isRerunTestExecution = rerunTests;
        if (this.isRerunTestExecution) {
            testList = new ArrayList<String>();
        }
        if (disableGroupList != null) {
            this.disableGroupList = disableGroupList;
        } else if (groupList != null) {
            this.groupList = groupList;
        } else if (testList != null) {
            this.isSingleTestExecution = true;
            this.singleExecTests = testList;
        }
    }

    @Override
    public void execute(Project project) {
        Path testsCachePath;
        Target target;
        this.filterTestGroups();
        this.report = project.buildOptions().testReport();
        this.coverage = project.buildOptions().codeCoverage();
        if (this.report || this.coverage) {
            this.testReport = new TestReport();
        }
        Path sourceRootPath = project.sourceRoot();
        try {
            target = new Target(sourceRootPath);
            testsCachePath = target.getTestsCachePath();
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)"error while creating target directory: ", (Throwable)e);
        }
        this.out.println();
        this.out.print("Running Tests");
        if (this.coverage) {
            this.out.print(" with Coverage");
            try {
                CodeCoverageUtils.deleteDirectory((File)target.getTestsCachePath().resolve("coverage").toFile());
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)"error while cleaning up coverage data", (Throwable)e);
            }
        }
        this.out.println();
        int result = 0;
        boolean hasTests = false;
        PackageCompilation packageCompilation = project.currentPackage().getCompilation();
        JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)packageCompilation, (JdkVersion)JdkVersion.JAVA_11);
        JarResolver jarResolver = jBallerinaBackend.jarResolver();
        for (ModuleId moduleId : project.currentPackage().moduleIds()) {
            Module module = project.currentPackage().module(moduleId);
            ModuleName moduleName = module.moduleName();
            TestSuite suite = jBallerinaBackend.testSuite(module).orElse(null);
            Path moduleTestCachePath = testsCachePath.resolve(moduleName.toString());
            if (suite == null) {
                if (!project.currentPackage().packageOrg().anonymous()) {
                    this.out.println();
                    this.out.println("\t" + moduleName.toString());
                }
                this.out.println("\tNo tests found");
                continue;
            }
            if (this.isRerunTestExecution && suite.getTests().isEmpty()) {
                this.out.println("\tNo failed test/s found in cache");
                continue;
            }
            if (this.isSingleTestExecution && suite.getTests().isEmpty()) {
                this.out.println("\tNo tests found with the given name/s");
                continue;
            }
            if (!hasTests) {
                hasTests = true;
            }
            if (this.isRerunTestExecution) {
                this.singleExecTests = this.readFailedTestsFromFile(target.path());
            }
            if (this.isSingleTestExecution || this.isRerunTestExecution) {
                suite.setTests(TesterinaUtils.getSingleExecutionTests((List)suite.getTests(), this.singleExecTests));
            }
            suite.setReportRequired(this.report || this.coverage);
            Collection dependencies = jarResolver.getJarFilePathsRequiredForTestExecution(moduleName);
            if (project.kind() == ProjectKind.SINGLE_FILE_PROJECT) {
                this.out.println("\t" + module.document((DocumentId)module.documentIds().iterator().next()).name());
            } else {
                this.out.println("\t" + module.moduleName().toString());
            }
            RunTestsTask.writeToJson(suite, moduleTestCachePath);
            int testResult = this.runTestSuit(moduleTestCachePath, target, dependencies, module);
            if (result == 0) {
                result = testResult;
            }
            if (!this.report && !this.coverage) continue;
            try {
                ModuleStatus moduleStatus = this.loadModuleStatusFromFile(moduleTestCachePath.resolve("module_status.json"));
                this.testReport.addModuleStatus(moduleName.toString(), moduleStatus);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)"error while generating test report", (Throwable)e);
            }
        }
        try {
            if (hasTests) {
                this.generateCoverage(project);
                this.generateHtmlReport(project, this.out, this.testReport, target);
            }
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)"error while generating test report :", (Throwable)e);
        }
        if (result != 0) {
            throw LauncherUtils.createLauncherException((String)"there are test failures");
        }
    }

    private void generateCoverage(Project project) throws IOException {
        if (!this.coverage) {
            return;
        }
        for (ModuleId moduleId : project.currentPackage().moduleIds()) {
            Module module = project.currentPackage().module(moduleId);
            CoverageReport coverageReport = new CoverageReport(module);
            this.testReport.addCoverage(module.moduleName().toString(), coverageReport.generateReport());
        }
    }

    private void filterTestGroups() {
        TesterinaRegistry testerinaRegistry = TesterinaRegistry.getInstance();
        if (this.disableGroupList != null) {
            testerinaRegistry.setGroups(this.disableGroupList);
            testerinaRegistry.setShouldIncludeGroups(false);
        } else if (this.groupList != null) {
            testerinaRegistry.setGroups(this.groupList);
            testerinaRegistry.setShouldIncludeGroups(true);
        }
    }

    private static void writeToJson(TestSuite testSuite, Path moduleTestsCachePath) {
        if (!Files.exists(moduleTestsCachePath, new LinkOption[0])) {
            try {
                Files.createDirectories(moduleTestsCachePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)("couldn't create test suite : " + e.toString()));
            }
        }
        Path tmpJsonPath = Paths.get(moduleTestsCachePath.toString(), "test_suit.json");
        File jsonFile = new File(tmpJsonPath.toString());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);){
            Gson gson = new Gson();
            String json = gson.toJson((Object)testSuite);
            writer.write(new String(json.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException((String)("couldn't write data to test suite file : " + e.toString()));
        }
    }

    private void generateHtmlReport(Project project, PrintStream out, TestReport testReport, Target target) {
        block22: {
            Path reportDir;
            if (!this.report && !this.coverage) {
                return;
            }
            if (testReport.getModuleStatus().size() <= 0) {
                return;
            }
            out.println();
            out.println("Generating Test Report");
            try {
                reportDir = target.getReportPath();
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)"error while creating report directory in target", (Throwable)e);
            }
            Object projectName = project.kind() == ProjectKind.SINGLE_FILE_PROJECT ? ProjectUtils.getJarFileName((Module)project.currentPackage().getDefaultModule()) + ".bal" : project.currentPackage().packageName().toString();
            testReport.setProjectName((String)projectName);
            testReport.finalizeTestResults(this.coverage);
            Gson gson = new Gson();
            String json = gson.toJson((Object)testReport).replaceAll("\\\\\\(", "(");
            File jsonFile = new File(reportDir.resolve("test_results.json").toString());
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(jsonFile), StandardCharsets.UTF_8);){
                writer.write(new String(json.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
                out.println("\t" + jsonFile.getAbsolutePath() + "\n");
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)("couldn't read data from the Json file : " + e.toString()));
            }
            Path reportZipPath = Paths.get(System.getProperty("ballerina.home"), new String[0]).resolve("lib").resolve("tools").resolve("coverage").resolve("report.zip");
            if (Files.exists(reportZipPath, new LinkOption[0])) {
                String content;
                try {
                    CodeCoverageUtils.unzipReportResources((InputStream)new FileInputStream(reportZipPath.toFile()), (File)reportDir.toFile());
                    content = Files.readString(reportDir.resolve("index.html"));
                    content = content.replace("__data__", json);
                }
                catch (IOException e) {
                    throw LauncherUtils.createLauncherException((String)("error occurred while preparing test report: " + e.toString()));
                }
                File htmlFile = new File(reportDir.resolve("index.html").toString());
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), StandardCharsets.UTF_8);){
                    writer.write(new String(content.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
                    out.println("\tView the test report at: file://" + Paths.get(htmlFile.getPath(), new String[0]).toAbsolutePath().normalize().toString());
                    break block22;
                }
                catch (IOException e) {
                    throw LauncherUtils.createLauncherException((String)("couldn't read data from the Json file : " + e.toString()));
                }
            }
            String reportToolsPath = "<ballerina.home>" + File.separator + "lib" + File.separator + "tools" + File.separator + "coverage" + File.separator + "report.zip";
            out.println("warning: Could not find the required HTML report tools for code coverage at " + reportToolsPath);
        }
    }

    private int runTestSuit(Path moduleTestCache, Target target, Collection<Path> testDependencies, Module module) {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(System.getProperty("java.command"));
        String mainClassName = "org.ballerinalang.test.runtime.Main";
        String orgName = module.packageInstance().packageOrg().toString();
        String packageName = module.packageInstance().packageName().toString();
        String jacocoAgentJarPath = Paths.get(System.getProperty("ballerina.home"), new String[0]).resolve("bre").resolve("lib").resolve("jacocoagent.jar").toString();
        try {
            if (this.coverage) {
                String agentCommand = "-javaagent:" + jacocoAgentJarPath + "=destfile=" + target.getTestsCachePath().resolve("coverage").resolve("ballerina.exec").toString();
                if (!".".equals(packageName)) {
                    agentCommand = agentCommand + ",includes=" + orgName + ".*";
                }
                cmdArgs.add(agentCommand);
            }
            String classPath = this.getClassPath(testDependencies);
            cmdArgs.addAll(Lists.of((Object[])new String[]{"-cp", classPath}));
            if (DebugUtils.isInDebugMode()) {
                cmdArgs.add(DebugUtils.getDebugArgs(this.err));
            }
            cmdArgs.add(mainClassName);
            cmdArgs.add(moduleTestCache.toString());
            cmdArgs.addAll(this.args);
            cmdArgs.add(target.path().toString());
            cmdArgs.add(orgName);
            cmdArgs.add(packageName);
            ProcessBuilder processBuilder = new ProcessBuilder(cmdArgs).inheritIO();
            Process proc = processBuilder.start();
            return proc.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw LauncherUtils.createLauncherException((String)("unable to run the tests: " + e.getMessage()));
        }
    }

    private String getClassPath(Collection<Path> dependencies) {
        StringJoiner cp = new StringJoiner(File.pathSeparator);
        dependencies.stream().map(Path::toString).forEach(cp::add);
        return cp.toString();
    }

    private ModuleStatus loadModuleStatusFromFile(Path statusJsonPath) throws IOException {
        Gson gson = new Gson();
        BufferedReader bufferedReader = Files.newBufferedReader(statusJsonPath, StandardCharsets.UTF_8);
        return (ModuleStatus)gson.fromJson((Reader)bufferedReader, ModuleStatus.class);
    }

    private List<String> readFailedTestsFromFile(Path rerunTestJsonPath) {
        List list;
        block8: {
            Gson gson = new Gson();
            rerunTestJsonPath = Paths.get(rerunTestJsonPath.toString(), "rerun_test.json");
            BufferedReader bufferedReader = Files.newBufferedReader(rerunTestJsonPath, StandardCharsets.UTF_8);
            try {
                list = (List)gson.fromJson((Reader)bufferedReader, ArrayList.class);
                if (bufferedReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw LauncherUtils.createLauncherException((String)"error while running failed tests. ", (Throwable)e);
                }
            }
            bufferedReader.close();
        }
        return list;
    }
}

