/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.utils;

import io.ballerina.cli.utils.BrowserLauncher;
import io.ballerina.cli.utils.TokenUpdater;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.ballerinalang.toml.model.Settings;
import org.ballerinalang.toml.parser.SettingsProcessor;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.util.RepoUtils;

public class CentralUtils {
    private CentralUtils() {
    }

    public static String authenticate(PrintStream errStream, String ballerinaCentralCliTokenUrl, Settings settings, Path settingsTomlFilePath) {
        String accessToken = CentralUtils.getAccessTokenOfCLI(settings);
        if (accessToken.isEmpty()) {
            try {
                errStream.println("Opening the web browser to " + ballerinaCentralCliTokenUrl + " for auto token update ...");
                BrowserLauncher.startInDefaultBrowser(ballerinaCentralCliTokenUrl);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException((String)("Access token is missing in " + settingsTomlFilePath.toString() + "\nAuto update failed. Please visit https://central.ballerina.io"));
            }
            long modifiedTimeOfFileAtStart = CentralUtils.getLastModifiedTimeOfFile(settingsTomlFilePath);
            TokenUpdater.execute(settingsTomlFilePath.toString());
            boolean waitForToken = true;
            while (waitForToken) {
                CentralUtils.pause();
                long modifiedTimeOfFileAfter = CentralUtils.getLastModifiedTimeOfFile(settingsTomlFilePath);
                if (modifiedTimeOfFileAtStart == modifiedTimeOfFileAfter) continue;
                settings = CentralUtils.readSettings();
                accessToken = CentralUtils.getAccessTokenOfCLI(settings);
                if (accessToken.isEmpty()) {
                    throw LauncherUtils.createLauncherException((String)("Access token is missing in " + settingsTomlFilePath.toString() + "\nPlease visit https://central.ballerina.io"));
                }
                waitForToken = false;
            }
        }
        return accessToken;
    }

    static String getAccessTokenOfCLI(Settings settings) {
        String tokenAsEnvVar = System.getenv("BALLERINA_CENTRAL_ACCESS_TOKEN");
        if (tokenAsEnvVar != null) {
            return tokenAsEnvVar;
        }
        if (settings.getCentral() != null) {
            return settings.getCentral().getAccessToken();
        }
        return "";
    }

    private static void pause() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            throw LauncherUtils.createLauncherException((String)"Error occurred while retrieving the access token");
        }
    }

    private static long getLastModifiedTimeOfFile(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return -1L;
        }
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException ex) {
            throw LauncherUtils.createLauncherException((String)("Error occurred when reading file for token " + path.toString()));
        }
    }

    public static Settings readSettings() {
        Path settingsFilePath = RepoUtils.createAndGetHomeReposPath().resolve("Settings.toml");
        try {
            return SettingsProcessor.parseTomlContentFromFile((Path)settingsFilePath);
        }
        catch (IOException e) {
            return new Settings();
        }
    }

    public static String getBallerinaCentralCliTokenUrl() {
        if (RepoUtils.SET_BALLERINA_STAGE_CENTRAL) {
            return "https://staging-central.ballerina.io/cli-token";
        }
        if (RepoUtils.SET_BALLERINA_DEV_CENTRAL) {
            return "https://dev-central.ballerina.io/cli-token";
        }
        return "https://central.ballerina.io/cli-token";
    }
}

