/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.utils;

import java.io.PrintStream;

public class DebugUtils {
    private static final String DEBUG_ARGS_JAVA11 = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y";
    private static final String JAVA_VERSION_PROP = "java.version";
    private static final String COMPATIBLE_JRE_VERSION = "11";

    public static boolean isInDebugMode() {
        return System.getProperty("debug") != null && !System.getProperty("debug").isEmpty();
    }

    public static String getDebugArgs(PrintStream errorStream) {
        String javaVersion = System.getProperty(JAVA_VERSION_PROP);
        if (javaVersion != null && !javaVersion.startsWith(COMPATIBLE_JRE_VERSION)) {
            errorStream.printf("WARNING: Incompatible JRE version '%s' found. Ballerina program debugging supports on JRE version '%s'%n", javaVersion, COMPATIBLE_JRE_VERSION);
        }
        return String.format("%s,address=*:%s", DEBUG_ARGS_JAVA11, System.getProperty("debug"));
    }
}

