/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.utils;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.ballerinalang.central.client.model.Package;

public class PrintUtils {
    private static PrintStream outStream = System.out;

    private PrintUtils() {
    }

    public static void printPackages(List<Package> packages, String terminalWidth) {
        int rightMargin = 3;
        int width = Integer.parseInt(terminalWidth) - rightMargin;
        int dateColWidth = 15;
        int versionColWidth = 8;
        int authorsColWidth = 15;
        double nameColFactor = 9.0;
        double descColFactor = 16.0;
        int additionalSpace = 7;
        double remainingWidth = (double)width - (double)(dateColWidth + versionColWidth + additionalSpace);
        int nameColWidth = (int)Math.round(remainingWidth * (nameColFactor / (nameColFactor + descColFactor)));
        int descColWidth = (int)Math.round(remainingWidth * (descColFactor / (nameColFactor + descColFactor)));
        int minDescColWidth = 60;
        PrintUtils.printTitle();
        PrintUtils.printTableHeader(dateColWidth, versionColWidth, nameColWidth, descColWidth, minDescColWidth, authorsColWidth);
        for (Package aPackage : packages) {
            PrintUtils.printPackage(aPackage, dateColWidth, versionColWidth, authorsColWidth, nameColWidth, descColWidth, minDescColWidth);
            outStream.println();
        }
        outStream.println();
        outStream.println(packages.size() + " packages found");
    }

    private static void printPackage(Package aPackage, int dateColWidth, int versionColWidth, int authorsColWidth, int nameColWidth, int descColWidth, int minDescColWidth) {
        PrintUtils.printInCLI("|" + aPackage.getOrganization() + "/" + aPackage.getName(), nameColWidth);
        String summary = PrintUtils.getSummary(aPackage);
        if (descColWidth >= minDescColWidth) {
            PrintUtils.printInCLI(summary, descColWidth - authorsColWidth);
            Object authors = "";
            List authorsArr = aPackage.getAuthors();
            if (!authorsArr.isEmpty()) {
                for (int j = 0; j < authorsArr.size(); ++j) {
                    authors = j == 0 ? (String)authorsArr.get(j) : (j == authorsArr.size() - 1 ? (String)authorsArr.get(j) : ", " + (String)authorsArr.get(j));
                }
            }
            PrintUtils.printInCLI((String)authors, authorsColWidth);
        } else {
            PrintUtils.printInCLI(summary, descColWidth);
        }
        PrintUtils.printInCLI(PrintUtils.getDateCreated(aPackage.getCreatedDate()), dateColWidth);
        PrintUtils.printInCLI(aPackage.getVersion(), versionColWidth);
    }

    private static void printTitle() {
        outStream.println();
        outStream.println("Ballerina Central");
        outStream.println("=================");
        outStream.println();
    }

    private static void printInCLI(String element, int charactersAllowed) {
        int lengthOfElement = element.length();
        if (lengthOfElement > charactersAllowed || lengthOfElement == charactersAllowed) {
            int margin = 3;
            String trimmedElement = element.substring(0, charactersAllowed - margin) + "...";
            outStream.print(trimmedElement + " |");
        } else {
            PrintUtils.printCharacter(element, charactersAllowed, " ", false);
        }
    }

    private static void printCharacter(String element, int charactersAllowed, String separator, boolean isDashElement) {
        int lengthOfElement = element.length();
        StringBuilder print = new StringBuilder(element);
        for (int i = 0; i < charactersAllowed - lengthOfElement; ++i) {
            print.append(separator);
        }
        if (isDashElement) {
            outStream.print(print + "-|");
        } else {
            outStream.print(print + " |");
        }
    }

    private static String getDateCreated(long timeInMillis) {
        Date date = new Date(timeInMillis);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-E");
        return df.format(date);
    }

    private static void printTableHeader(int dateColWidth, int versionColWidth, int nameColWidth, int descColWidth, int minDescColWidth, int authorsColWidth) {
        PrintUtils.printHeadingRow(dateColWidth, versionColWidth, nameColWidth, descColWidth, minDescColWidth, authorsColWidth);
        PrintUtils.printDashRow(dateColWidth, versionColWidth, nameColWidth, descColWidth, minDescColWidth, authorsColWidth);
    }

    private static void printHeadingRow(int dateColWidth, int versionColWidth, int nameColWidth, int descColWidth, int minDescColWidth, int authorsColWidth) {
        PrintUtils.printInCLI("|NAME", nameColWidth);
        if (descColWidth >= minDescColWidth) {
            PrintUtils.printInCLI("DESCRIPTION", descColWidth - authorsColWidth);
            PrintUtils.printInCLI("AUTHOR", authorsColWidth);
        } else {
            PrintUtils.printInCLI("DESCRIPTION", descColWidth);
        }
        PrintUtils.printInCLI("DATE", dateColWidth);
        PrintUtils.printInCLI("VERSION", versionColWidth);
        outStream.println();
    }

    private static void printDashRow(int dateColWidth, int versionColWidth, int nameColWidth, int descColWidth, int minDescColWidth, int authorsColWidth) {
        PrintUtils.printCharacter("|-", nameColWidth, "-", true);
        if (descColWidth >= minDescColWidth) {
            PrintUtils.printCharacter("-", descColWidth - authorsColWidth, "-", true);
            PrintUtils.printCharacter("-", authorsColWidth, "-", true);
        } else {
            PrintUtils.printCharacter("-", descColWidth, "-", true);
        }
        PrintUtils.printCharacter("-", dateColWidth, "-", true);
        PrintUtils.printCharacter("-", versionColWidth, "-", true);
        outStream.println();
    }

    private static String getSummary(Package aPackage) {
        String summary = aPackage.getSummary();
        if (summary == null) {
            String readme = aPackage.getReadme();
            if (readme == null) {
                return "";
            }
            summary = readme.substring(0, readme.indexOf(10));
        }
        return summary;
    }
}

