/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.code.generator;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.ballerinalang.code.generator.GeneratorConstants;
import org.ballerinalang.code.generator.exception.CodeGeneratorException;
import org.ballerinalang.code.generator.model.ClientContextHolder;

public class CodeGenerator {
    public String generateOutput(GeneratorConstants.GenType type, ClientContextHolder context) throws CodeGeneratorException {
        String output = "";
        switch (type) {
            case CLIENT: {
                return this.getConvertedString(context, GeneratorConstants.DEFAULT_CLIENT_DIR, "client");
            }
            case OPENAPI: {
                return this.getConvertedString(context, GeneratorConstants.DEFAULT_OPEN_API_DIR, "skeleton");
            }
            case SWAGGER: {
                return this.getConvertedString(context, GeneratorConstants.DEFAULT_SWAGGER_DIR, "skeleton");
            }
        }
        return output;
    }

    public void writeGeneratedSource(GeneratorConstants.GenType type, ClientContextHolder context, String outPath) throws CodeGeneratorException {
        try (PrintWriter writer = new PrintWriter(outPath, "UTF-8");){
            String generatedSource = this.generateOutput(type, context);
            writer.println(generatedSource);
        }
        catch (FileNotFoundException e) {
            throw new CodeGeneratorException("Error while writing converted string due to output file not found", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new CodeGeneratorException("Error while writing converted string due to unsupported encoding", e);
        }
    }

    public String getConvertedString(Object object, String templateDir, String templateName) throws CodeGeneratorException {
        Template template = this.compileTemplate(templateDir, templateName);
        Context context = Context.newBuilder(object).resolver(MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE).build();
        try {
            return template.apply(context);
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Error while generating converted string", e);
        }
    }

    private Template compileTemplate(String defaultTemplateDir, String templateName) throws CodeGeneratorException {
        String templatesDirPath = System.getProperty("templates.dir.path", defaultTemplateDir);
        ClassPathTemplateLoader cpTemplateLoader = new ClassPathTemplateLoader(templatesDirPath);
        FileTemplateLoader fileTemplateLoader = new FileTemplateLoader(templatesDirPath);
        cpTemplateLoader.setSuffix(".mustache");
        fileTemplateLoader.setSuffix(".mustache");
        Handlebars handlebars = new Handlebars().with(cpTemplateLoader, fileTemplateLoader);
        handlebars.registerHelpers((Class)StringHelpers.class);
        handlebars.registerHelper("equals", (object, options) -> {
            Object param0 = options.param(0);
            if (param0 == null) {
                throw new IllegalArgumentException("found 'null', expected 'string'");
            }
            CharSequence result = object != null && object.toString().equals(param0.toString()) ? options.fn(options.context) : null;
            return result;
        });
        try {
            return handlebars.compile(templateName);
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Error while compiling template", e);
        }
    }
}

