/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.code.generator.model;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.code.generator.exception.CodeGeneratorException;
import org.ballerinalang.code.generator.model.EndpointContextHolder;
import org.ballerinalang.code.generator.model.ResourceContextHolder;
import org.ballerinalang.model.tree.EndpointNode;
import org.ballerinalang.model.tree.ResourceNode;
import org.ballerinalang.model.tree.ServiceNode;

public class ClientContextHolder {
    private String name;
    private List<ResourceContextHolder> resources;
    private List<EndpointContextHolder> endpoints;

    public static ClientContextHolder buildContext(ServiceNode service, List<EndpointNode> endpoints) throws CodeGeneratorException {
        ClientContextHolder context = new ClientContextHolder();
        context.name = service.getName().getValue();
        context.resources = new ArrayList<ResourceContextHolder>();
        context.endpoints = new ArrayList<EndpointContextHolder>();
        for (EndpointNode ep : endpoints) {
            EndpointContextHolder epContext = EndpointContextHolder.buildContext(service, ep);
            if (epContext == null) continue;
            context.endpoints.add(EndpointContextHolder.buildContext(service, ep));
        }
        for (ResourceNode resource : service.getResources()) {
            ResourceContextHolder operation = ResourceContextHolder.buildContext(resource);
            context.resources.add(operation);
        }
        return context;
    }

    public String getName() {
        return this.name;
    }

    public List<ResourceContextHolder> getResources() {
        return this.resources;
    }

    public List<EndpointContextHolder> getEndpoints() {
        return this.endpoints;
    }
}

