/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.code.generator.model;

import org.ballerinalang.model.tree.VariableNode;
import org.ballerinalang.model.tree.types.TypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;

public class ParameterContextHolder {
    private String type;
    private String name;
    private String defaultValue;
    private String example;

    public static ParameterContextHolder buildContext(VariableNode parameter) {
        ParameterContextHolder context = new ParameterContextHolder();
        TypeNode type = parameter.getTypeNode();
        if (type instanceof BLangValueType) {
            context.type = ((BLangValueType)parameter.getTypeNode()).getTypeKind().typeName();
        } else if (type instanceof BLangUserDefinedType) {
            context.type = ((BLangUserDefinedType)parameter.getTypeNode()).getTypeName().getValue();
        }
        if (context.isIgnoredType(context.type)) {
            return null;
        }
        context.name = parameter.getName().toString();
        context.defaultValue = context.getDefaultValue(context.type, context.name);
        context.example = "";
        return context;
    }

    private boolean isIgnoredType(String type) {
        return type == null || "Request".equals(type);
    }

    private String getDefaultValue(String type, String name) {
        String defaultValue;
        switch (type) {
            case "int": {
                defaultValue = "0";
                break;
            }
            case "float": {
                defaultValue = "0.0";
                break;
            }
            case "boolean": {
                defaultValue = "false";
                break;
            }
            case "blob": 
            case "string": {
                defaultValue = '\"' + name + '\"';
                break;
            }
            default: {
                defaultValue = "{}";
            }
        }
        return defaultValue;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getExample() {
        return this.example;
    }
}

