/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.code.generator.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ballerinalang.code.generator.exception.CodeGeneratorException;
import org.ballerinalang.code.generator.model.ParameterContextHolder;
import org.ballerinalang.code.generator.util.GeneratorUtils;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ResourceNode;
import org.ballerinalang.model.tree.VariableNode;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class ResourceContextHolder {
    private String method;
    private String name;
    private String contentType;
    private List<ParameterContextHolder> parameters;
    private boolean isMultiMethod;
    private List<String> supportedMethods;
    private String path;

    public static ResourceContextHolder buildContext(ResourceNode resource) throws CodeGeneratorException {
        ResourceContextHolder context = new ResourceContextHolder();
        context.name = resource.getName().getValue();
        context.parameters = new ArrayList<ParameterContextHolder>();
        for (VariableNode node : resource.getParameters()) {
            ParameterContextHolder parameter = ParameterContextHolder.buildContext(node);
            if (parameter == null) continue;
            context.parameters.add(parameter);
        }
        AnnotationAttachmentNode ann = GeneratorUtils.getAnnotationFromList("ResourceConfig", "http", resource.getAnnotationAttachments());
        if (ann == null) {
            throw new CodeGeneratorException("Incomplete resource configuration found");
        }
        BLangRecordLiteral bLiteral = (BLangRecordLiteral)((BLangAnnotationAttachment)ann).getExpression();
        List list = bLiteral.getKeyValuePairs();
        Map<String, String[]> attrs = GeneratorUtils.getKeyValuePairAsMap(list);
        if (attrs.get("methods") != null) {
            if (attrs.get("methods").length > 1) {
                context.isMultiMethod = true;
                context.supportedMethods = Arrays.asList((Object[])attrs.get("methods"));
            } else {
                context.method = attrs.get("methods")[0];
            }
        } else {
            context.method = null;
        }
        context.contentType = attrs.get("consumes") != null ? attrs.get("consumes")[0] : null;
        String path = attrs.get("path") != null ? attrs.get("path")[0] : null;
        context.path = context.getTemplatePath(path);
        return context;
    }

    private String getTemplatePath(String path) {
        if (path == null) {
            return null;
        }
        String templatePath = path.replaceAll("\\{", "{{");
        templatePath = templatePath.replaceAll("}", "}}");
        return templatePath;
    }

    public String getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getContentType() {
        return this.contentType;
    }

    public List<ParameterContextHolder> getParameters() {
        return this.parameters;
    }

    public boolean isMultiMethod() {
        return this.isMultiMethod;
    }

    public List<String> getSupportedMethods() {
        return this.supportedMethods;
    }
}

