/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.code.generator.util;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ballerinalang.code.generator.CodeGenerator;
import org.ballerinalang.code.generator.GeneratorConstants;
import org.ballerinalang.code.generator.exception.CodeGeneratorException;
import org.ballerinalang.code.generator.model.ClientContextHolder;
import org.ballerinalang.code.generator.util.GeneratorUtils;
import org.ballerinalang.compiler.plugins.AbstractCompilerPlugin;
import org.ballerinalang.compiler.plugins.SupportedAnnotationPackages;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.EndpointNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

@SupportedAnnotationPackages(value={"ballerina.swagger"})
public class ClientGeneratorPlugin
extends AbstractCompilerPlugin {
    List<EndpointNode> endpoints;

    public void init(DiagnosticLog diagnosticLog) {
        this.endpoints = new ArrayList<EndpointNode>();
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        CodeGenerator codegen = new CodeGenerator();
        PrintStream err = System.err;
        AnnotationAttachmentNode config = GeneratorUtils.getAnnotationFromList("ClientConfig", "swagger", annotations);
        if (this.isClientGenerationEnabled(config)) {
            try {
                ClientContextHolder context = ClientContextHolder.buildContext(serviceNode, this.endpoints);
                codegen.writeGeneratedSource(GeneratorConstants.GenType.CLIENT, context, this.getOutputFilePath(serviceNode));
            }
            catch (CodeGeneratorException e) {
                err.println("Client code was not generated: " + e.getMessage());
            }
        }
    }

    public void process(EndpointNode endpointNode, List<AnnotationAttachmentNode> annotations) {
        AnnotationAttachmentNode config = GeneratorUtils.getAnnotationFromList("ClientEndpoint", "swagger", annotations);
        if (config != null) {
            this.endpoints.add(endpointNode);
        }
    }

    private String getOutputFilePath(ServiceNode serviceNode) {
        String cUnit = serviceNode.getPosition().getSource().getCompilationUnitName();
        String dir = cUnit.substring(0, cUnit.lastIndexOf(File.separator) + 1);
        String file = serviceNode.getName().getValue().toLowerCase(Locale.ENGLISH) + "_client.bal";
        return dir + file;
    }

    private boolean isClientGenerationEnabled(AnnotationAttachmentNode ann) {
        if (ann == null) {
            return false;
        }
        BLangRecordLiteral bLiteral = (BLangRecordLiteral)((BLangAnnotationAttachment)ann).getExpression();
        List list = bLiteral.getKeyValuePairs();
        Map<String, String[]> attrs = GeneratorUtils.getKeyValuePairAsMap(list);
        String val = attrs.get("generate")[0];
        boolean isClientRequested = Boolean.parseBoolean(val);
        return isClientRequested;
    }
}

