/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.code.generator.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrayLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class GeneratorUtils {
    public static AnnotationAttachmentNode getAnnotationFromList(String name, String pkg, List<? extends AnnotationAttachmentNode> annotations) {
        AnnotationAttachmentNode annotation = null;
        if (name == null || pkg == null) {
            return null;
        }
        for (AnnotationAttachmentNode annotationAttachmentNode : annotations) {
            if (!pkg.equals(annotationAttachmentNode.getPackageAlias().getValue()) || !name.equals(annotationAttachmentNode.getAnnotationName().getValue())) continue;
            annotation = annotationAttachmentNode;
        }
        return annotation;
    }

    public static Map<String, String[]> getKeyValuePairAsMap(List<BLangRecordLiteral.BLangRecordKeyValue> list) {
        HashMap<String, String[]> attrMap = new HashMap<String, String[]>();
        list.forEach(attr -> {
            if (attr.getValue() instanceof BLangLiteral) {
                attrMap.put(attr.getKey().toString(), new String[]{attr.getValue().toString()});
            } else if (attr.getValue() instanceof BLangArrayLiteral) {
                List exprs = ((BLangArrayLiteral)attr.getValue()).getExpressions();
                String[] values = new String[exprs.size()];
                for (int i = 0; i < exprs.size(); ++i) {
                    values[i] = ((BLangLiteral)exprs.get(i)).getValue().toString();
                }
                attrMap.put(attr.getKey().toString(), values);
            }
        });
        return attrMap;
    }
}

