/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.code.generator.model;

import java.util.List;
import java.util.Map;
import org.ballerinalang.code.generator.util.GeneratorUtils;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.EndpointNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.expressions.SimpleVariableReferenceNode;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;

public class EndpointContextHolder {
    private String name;
    private String host;
    private String port;
    private String basePath;
    private String url;

    public static EndpointContextHolder buildContext(ServiceNode service, EndpointNode ep) {
        EndpointContextHolder endpoint = null;
        for (SimpleVariableReferenceNode node : service.getBoundEndpoints()) {
            if (!node.getVariableName().equals(ep.getName())) continue;
            endpoint = new EndpointContextHolder();
            AnnotationAttachmentNode ann = GeneratorUtils.getAnnotationFromList("ServiceConfig", "http", service.getAnnotationAttachments());
            endpoint.extractDetails(ep, ann);
            break;
        }
        return endpoint;
    }

    private void extractDetails(EndpointNode ep, AnnotationAttachmentNode ann) {
        this.name = ep.getName().getValue();
        BLangRecordLiteral bLiteral = (BLangRecordLiteral)ep.getConfigurationExpression();
        List list = bLiteral.getKeyValuePairs();
        Map<String, String[]> configs = GeneratorUtils.getKeyValuePairAsMap(list);
        String httpsPort = configs.get("httpsPort") != null ? configs.get("httpsPort")[0] : null;
        this.host = configs.get("host") != null ? configs.get("host")[0] : null;
        this.port = configs.get("port") != null ? configs.get("port")[0] : null;
        bLiteral = (BLangRecordLiteral)((BLangAnnotationAttachment)ann).getExpression();
        List attrList = bLiteral.getKeyValuePairs();
        Map<String, String[]> attrs = GeneratorUtils.getKeyValuePairAsMap(attrList);
        this.basePath = attrs.get("basePath") != null ? attrs.get("basePath")[0] : null;
        StringBuffer sb = new StringBuffer();
        if (httpsPort != null) {
            sb.append("https://");
            this.port = httpsPort;
        } else {
            sb.append("http://");
        }
        if (this.host == null) {
            this.host = "localhost";
        }
        if (this.port == null) {
            this.port = "80";
        }
        this.url = sb.append(this.host).append(':').append(this.port).append(this.basePath).toString();
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }
}

