/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.code.generator;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.ballerinalang.code.generator.GeneratorConstants;
import org.ballerinalang.code.generator.exception.CodeGeneratorException;
import org.ballerinalang.code.generator.model.ClientContextHolder;

public class CodeGenerator {
    public static String generateOutput(GeneratorConstants.GenType type, ClientContextHolder context) throws CodeGeneratorException {
        String output = "";
        switch (type) {
            case CLIENT: {
                return CodeGenerator.getConvertedString(context, "/templates/client", "client");
            }
            case OPENAPI: {
                return CodeGenerator.getConvertedString(context, "/templates/oas3", "skeleton");
            }
            case SWAGGER: {
                return CodeGenerator.getConvertedString(context, "/templates/swagger2", "skeleton");
            }
        }
        return output;
    }

    public static void writeFile(Path targetDirPath, String fileName, String fileContent) throws CodeGeneratorException {
        if (targetDirPath == null) {
            throw new CodeGeneratorException("Target file directory path is null.");
        }
        try {
            if (!Files.exists(targetDirPath, new LinkOption[0])) {
                Files.createDirectories(targetDirPath, new FileAttribute[0]);
            }
            Path clientFilePath = Paths.get(targetDirPath.toString(), fileName);
            Files.write(clientFilePath, fileContent.getBytes("UTF-8"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Error while writing generated client to a file.", e);
        }
    }

    private static String getConvertedString(Object object, String templateDir, String templateName) throws CodeGeneratorException {
        Template template = CodeGenerator.compileTemplate(templateDir, templateName);
        Context context = Context.newBuilder(object).resolver(MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE).build();
        try {
            return template.apply(context);
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Error while generating converted string", e);
        }
    }

    private static Template compileTemplate(String defaultTemplateDir, String templateName) throws CodeGeneratorException {
        defaultTemplateDir = defaultTemplateDir.replaceAll("\\\\", "/");
        String templatesDirPath = System.getProperty("templates.dir.path", defaultTemplateDir);
        ClassPathTemplateLoader cpTemplateLoader = new ClassPathTemplateLoader(templatesDirPath);
        FileTemplateLoader fileTemplateLoader = new FileTemplateLoader(templatesDirPath);
        cpTemplateLoader.setSuffix(".mustache");
        fileTemplateLoader.setSuffix(".mustache");
        Handlebars handlebars = new Handlebars().with(cpTemplateLoader, fileTemplateLoader);
        handlebars.registerHelpers((Class)StringHelpers.class);
        handlebars.registerHelper("equals", (object, options) -> {
            Object param0 = options.param(0);
            if (param0 == null) {
                throw new IllegalArgumentException("found 'null', expected 'string'");
            }
            CharSequence result = object != null ? (object.toString().equals(param0.toString()) ? options.fn(options.context) : options.inverse()) : null;
            return result;
        });
        try {
            return handlebars.compile(templateName);
        }
        catch (IOException e) {
            throw new CodeGeneratorException("Error while compiling template", e);
        }
    }
}

