/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.code.generator.model;

import java.util.List;
import java.util.Map;
import org.ballerinalang.code.generator.util.GeneratorUtils;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.NodeKind;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;

public class EndpointContextHolder {
    private String name;
    private String host;
    private String port;
    private String basePath;
    private String url;

    public static EndpointContextHolder buildContext(BLangService service, BLangSimpleVariable ep) {
        EndpointContextHolder endpoint = null;
        if (service == null || service.getAttachedExprs().isEmpty() || ((BLangExpression)service.getAttachedExprs().get(0)).getKind() != NodeKind.SIMPLE_VARIABLE_REF) {
            return null;
        }
        for (BLangExpression node : service.getAttachedExprs()) {
            BLangSimpleVarRef variableRef;
            if (!(node instanceof BLangSimpleVarRef) || !(variableRef = (BLangSimpleVarRef)node).getVariableName().equals((Object)ep.getName())) continue;
            endpoint = new EndpointContextHolder();
            AnnotationAttachmentNode ann = GeneratorUtils.getAnnotationFromList("ServiceConfig", "http", service.getAnnotationAttachments());
            endpoint.extractDetails(ep, ann);
            break;
        }
        return endpoint;
    }

    private void extractDetails(BLangSimpleVariable ep, AnnotationAttachmentNode ann) {
        BLangRecordLiteral bLiteral;
        List attrList;
        Map<String, String[]> attrs;
        this.name = ep.getName().getValue();
        BLangTypeInit bTypeInit = (BLangTypeInit)ep.getInitialExpression();
        List list = bTypeInit.argsExpr;
        String httpsPort = null;
        if (list.size() == 1 && list.get(0) instanceof BLangLiteral) {
            this.port = ((BLangExpression)list.get(0)).toString();
        }
        if (list.size() > 1 && list.get(1) instanceof BLangNamedArgsExpression && ((BLangNamedArgsExpression)list.get(1)).getExpression() instanceof BLangRecordLiteral) {
            BLangRecordLiteral bLangRecordLiteral = (BLangRecordLiteral)((BLangNamedArgsExpression)list.get(1)).getExpression();
            Map<String, String[]> configs = GeneratorUtils.getKeyValuePairAsMap(bLangRecordLiteral.keyValuePairs);
            httpsPort = configs.get("httpsPort") != null ? configs.get("httpsPort")[0] : null;
            this.host = configs.get("host") != null ? configs.get("host")[0] : null;
        }
        this.basePath = (attrs = GeneratorUtils.getKeyValuePairAsMap(attrList = (bLiteral = (BLangRecordLiteral)((BLangAnnotationAttachment)ann).getExpression()).getKeyValuePairs())).get("basePath") != null ? attrs.get("basePath")[0] : null;
        StringBuffer sb = new StringBuffer();
        if (httpsPort != null) {
            sb.append("https://");
            this.port = httpsPort;
        } else {
            sb.append("http://");
        }
        if (this.host == null) {
            this.host = "localhost";
        }
        if (this.port == null) {
            this.port = "80";
        }
        this.url = sb.append(this.host).append(':').append(this.port).append(this.basePath).toString();
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }
}

