/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.config;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.config.ConfigProcessor;
import org.ballerinalang.config.utils.ConfigFileParserException;

public class ConfigRegistry {
    private static final ConfigRegistry configRegistry = new ConfigRegistry();
    private static final String STRING_NULL_VALUE = null;
    private Map<String, String> globalConfigs = new HashMap<String, String>();
    private Map<String, Map<String, String>> instanceConfigs = new HashMap<String, Map<String, String>>();
    private ConfigProcessor confProcessor = new ConfigProcessor(this);

    private ConfigRegistry() {
    }

    public static ConfigRegistry getInstance() {
        return configRegistry;
    }

    public void initRegistry(Map<String, String> runtimeParams) {
        this.confProcessor.setRuntimeConfiguration(runtimeParams);
    }

    public void loadConfigurations() throws ConfigFileParserException {
        this.confProcessor.processConfiguration();
    }

    protected void setGlobalConfigs(Map<String, String> globalConfigMap) {
        this.globalConfigs.putAll(globalConfigMap);
    }

    public String getGlobalConfigValue(String configKey) {
        if (this.globalConfigs.isEmpty() || this.globalConfigs.get(configKey) == null) {
            return STRING_NULL_VALUE;
        }
        return this.globalConfigs.get(configKey);
    }

    protected void setInstanceConfigs(Map<String, Map<String, String>> instanceConfigMap) {
        this.instanceConfigs.putAll(instanceConfigMap);
    }

    public String getInstanceConfigValue(String instanceId, String configKey) {
        if (this.instanceConfigs.isEmpty() || this.instanceConfigs.get(instanceId) == null) {
            return STRING_NULL_VALUE;
        }
        Map<String, String> instanceConfig = this.instanceConfigs.get(instanceId);
        String configValue = instanceConfig.get(configKey);
        if (configValue == null) {
            return STRING_NULL_VALUE;
        }
        return configValue;
    }
}

