/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bcl.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.apache.commons.lang3.StringEscapeUtils;
import org.ballerinalang.bcl.parser.BConfig;
import org.ballerinalang.toml.antlr4.TomlBaseListener;
import org.ballerinalang.toml.antlr4.TomlParser;

public class BConfigLangListener
extends TomlBaseListener {
    private static final String ENCRYPTED_FIELD_REGEX = "@encrypted:\\{(.*)\\}";
    private static final String ENV_VARIABLE_REGEX = "@env:\\{([a-zA-Z_]+[a-zA-Z0-9_]*)\\}";
    private static final String CONFIG_KEY_SEPARATOR = ".";
    private static final Pattern ENV_VAR_PATTERN = Pattern.compile("@env:\\{([a-zA-Z_]+[a-zA-Z0-9_]*)\\}");
    private BConfig configEntries;
    private String currentTableHeader;
    private StringBuilder currentKey;
    private Object currentValue;
    private boolean hasEncryptedFields;

    public BConfigLangListener(BConfig configEntries) {
        this.configEntries = configEntries;
    }

    public void exitStdTable(TomlParser.StdTableContext context) {
        this.currentTableHeader = this.currentKey.toString();
        this.currentKey = null;
    }

    public void enterKey(TomlParser.KeyContext context) {
        this.currentKey = new StringBuilder();
    }

    public void exitKeyVal(TomlParser.KeyValContext context) {
        this.currentKey = null;
    }

    public void enterDotSep(TomlParser.DotSepContext context) {
        this.currentKey.append(context.getText());
    }

    public void enterQuotedKey(TomlParser.QuotedKeyContext context) {
        this.currentKey = this.currentKey.append(context.basicString().basicStringValue().getText());
    }

    public void enterUnquotedKey(TomlParser.UnquotedKeyContext context) {
        this.currentKey = this.currentKey.append(context.getText());
    }

    public void enterBasicString(TomlParser.BasicStringContext context) {
        String stringVal = context.basicStringValue().getText();
        stringVal = StringEscapeUtils.unescapeJava((String)stringVal);
        this.currentValue = this.getResolvedStringValue(stringVal);
    }

    public void enterLiteralString(TomlParser.LiteralStringContext context) {
        String stringVal = context.LITERALCHAR().stream().map(x -> x.getText()).collect(Collectors.joining());
        this.currentValue = this.getResolvedStringValue(stringVal);
    }

    public void enterMlBasicString(TomlParser.MlBasicStringContext context) {
        String stringVal = context.mlBasicBody().basicChar().stream().map(x -> x.getText()).collect(Collectors.joining());
        this.currentValue = this.getResolvedStringValue(stringVal);
    }

    public void enterMlLiteralString(TomlParser.MlLiteralStringContext context) {
        String stringVal = context.mlLiteralBody().MLLITERALCHAR().stream().map(x -> x.getText()).collect(Collectors.joining());
        this.currentValue = this.getResolvedStringValue(stringVal);
    }

    public void enterDecInt(TomlParser.DecIntContext context) {
        if (!(context.getParent() instanceof TomlParser.FloatIntPartContext)) {
            try {
                this.currentValue = Long.parseLong(context.getText());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("invalid decimal int value: " + context.getText());
            }
        }
    }

    public void enterBinInt(TomlParser.BinIntContext context) {
        try {
            this.currentValue = Long.parseLong(context.getText(), 2);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid binary int value: " + context.getText());
        }
    }

    public void enterOctInt(TomlParser.OctIntContext context) {
        try {
            this.currentValue = Long.parseLong(context.getText(), 8);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid octal int value: " + context.getText());
        }
    }

    public void enterHexInt(TomlParser.HexIntContext context) {
        try {
            this.currentValue = Long.parseLong(context.getText(), 16);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid hexadecimal int value: " + context.getText());
        }
    }

    public void enterFloatingPoint(TomlParser.FloatingPointContext context) {
        try {
            this.currentValue = Double.parseDouble(context.getText());
            context.exitRule((ParseTreeListener)this);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid float value: " + context.getText());
        }
    }

    public void enterBool(TomlParser.BoolContext context) {
        this.currentValue = Boolean.parseBoolean(context.getText());
    }

    public void enterTable(TomlParser.TableContext context) {
    }

    public void exitVal(TomlParser.ValContext context) {
        String configKey = this.currentTableHeader != null ? this.currentTableHeader + CONFIG_KEY_SEPARATOR + this.currentKey.toString() : this.currentKey.toString();
        this.configEntries.addConfiguration(configKey, this.currentValue);
        this.currentValue = null;
    }

    public void exitToml(TomlParser.TomlContext context) {
        this.configEntries.setHasEncryptedValues(this.hasEncryptedFields);
    }

    private String resolveEnvVariables(String config) {
        Matcher envVarMatcher = ENV_VAR_PATTERN.matcher(config);
        if (!envVarMatcher.find()) {
            return config;
        }
        String value = System.getenv(envVarMatcher.group(1));
        return value != null ? value : config;
    }

    private String getResolvedStringValue(String value) {
        if (!value.matches(ENCRYPTED_FIELD_REGEX)) {
            return this.resolveEnvVariables(value);
        }
        this.hasEncryptedFields = true;
        return value;
    }
}

