/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.crypto.nativeimpl;

import java.security.PrivateKey;
import java.security.PublicKey;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.stdlib.crypto.CryptoUtils;

public class Sign {
    public static Object signRsaMd5(ArrayValue inputValue, MapValue<?, ?> privateKey) {
        byte[] input = inputValue.getBytes();
        PrivateKey key = (PrivateKey)privateKey.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        return CryptoUtils.sign("MD5withRSA", key, input);
    }

    public static Object signRsaSha1(ArrayValue inputValue, MapValue<?, ?> privateKey) {
        byte[] input = inputValue.getBytes();
        PrivateKey key = (PrivateKey)privateKey.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        return CryptoUtils.sign("SHA1withRSA", key, input);
    }

    public static Object signRsaSha256(ArrayValue inputValue, MapValue<?, ?> privateKey) {
        byte[] input = inputValue.getBytes();
        PrivateKey key = (PrivateKey)privateKey.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        return CryptoUtils.sign("SHA256withRSA", key, input);
    }

    public static Object signRsaSha384(ArrayValue inputValue, MapValue<?, ?> privateKey) {
        byte[] input = inputValue.getBytes();
        PrivateKey key = (PrivateKey)privateKey.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        return CryptoUtils.sign("SHA384withRSA", key, input);
    }

    public static Object signRsaSha512(ArrayValue inputValue, MapValue<?, ?> privateKey) {
        byte[] input = inputValue.getBytes();
        PrivateKey key = (PrivateKey)privateKey.getNativeData("NATIVE_DATA_PRIVATE_KEY");
        return CryptoUtils.sign("SHA512withRSA", key, input);
    }

    public static Object verifyRsaMd5Signature(ArrayValue dataValue, ArrayValue signatureValue, MapValue<?, ?> publicKey) {
        byte[] data = dataValue.getBytes();
        byte[] signature = signatureValue.getBytes();
        PublicKey key = (PublicKey)publicKey.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        return CryptoUtils.verify("MD5withRSA", key, data, signature);
    }

    public static Object verifyRsaSha1Signature(ArrayValue dataValue, ArrayValue signatureValue, MapValue<?, ?> publicKey) {
        byte[] data = dataValue.getBytes();
        byte[] signature = signatureValue.getBytes();
        PublicKey key = (PublicKey)publicKey.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        return CryptoUtils.verify("SHA1withRSA", key, data, signature);
    }

    public static Object verifyRsaSha256Signature(ArrayValue dataValue, ArrayValue signatureValue, MapValue<?, ?> publicKey) {
        byte[] data = dataValue.getBytes();
        byte[] signature = signatureValue.getBytes();
        PublicKey key = (PublicKey)publicKey.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        return CryptoUtils.verify("SHA256withRSA", key, data, signature);
    }

    public static Object verifyRsaSha384Signature(ArrayValue dataValue, ArrayValue signatureValue, MapValue<?, ?> publicKey) {
        byte[] data = dataValue.getBytes();
        byte[] signature = signatureValue.getBytes();
        PublicKey key = (PublicKey)publicKey.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        return CryptoUtils.verify("SHA384withRSA", key, data, signature);
    }

    public static Object verifyRsaSha512Signature(ArrayValue dataValue, ArrayValue signatureValue, MapValue<?, ?> publicKey) {
        byte[] data = dataValue.getBytes();
        byte[] signature = signatureValue.getBytes();
        PublicKey key = (PublicKey)publicKey.getNativeData("NATIVE_DATA_PUBLIC_KEY");
        return CryptoUtils.verify("SHA512withRSA", key, data, signature);
    }
}

