/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.file.nativeimpl;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.stdlib.file.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final String CURRENT_DIR_PROPERTY_KEY = "user.dir";
    private static final String TEMP_DIR_PROPERTY_KEY = "java.io.tmpdir";
    private static BType fileInfoType;

    public static BString getCurrentDirectory() {
        return StringUtils.fromString((String)FileUtils.getSystemProperty(CURRENT_DIR_PROPERTY_KEY));
    }

    public static boolean exists(BString path) {
        return Files.exists(Paths.get(path.getValue(), new String[0]), new LinkOption[0]);
    }

    public static Object createDir(BString dir, boolean parentDirs) {
        try {
            Path dirPath = parentDirs ? Files.createDirectories(Paths.get(dir.getValue(), new String[0]), new FileAttribute[0]) : Files.createDirectory(Paths.get(dir.getValue(), new String[0]), new FileAttribute[0]);
            return StringUtils.fromString((String)dirPath.toAbsolutePath().toString());
        }
        catch (FileAlreadyExistsException e) {
            String msg = "File already exists. Failed to create the file: " + dir;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("InvalidOperationError", msg);
        }
        catch (SecurityException e) {
            String msg = "Permission denied. Failed to create the file: " + dir;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("PermissionError", msg);
        }
        catch (IOException e) {
            String msg = "IO error while creating the file " + dir;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("FileSystemError", msg);
        }
        catch (Exception e) {
            String msg = "Error while creating the file " + dir;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("FileSystemError", msg);
        }
    }

    public static Object rename(BString oldPath, BString newPath) {
        Path oldFilePath = Paths.get(oldPath.getValue(), new String[0]);
        Path newFilePath = Paths.get(newPath.getValue(), new String[0]);
        if (Files.notExists(oldFilePath, new LinkOption[0])) {
            return FileUtils.getBallerinaError("FileNotFoundError", "File not found: " + oldFilePath.toAbsolutePath());
        }
        try {
            Files.move(oldFilePath.toAbsolutePath(), newFilePath.toAbsolutePath(), new CopyOption[0]);
            return null;
        }
        catch (FileAlreadyExistsException e) {
            return FileUtils.getBallerinaError("InvalidOperationError", "File already exists in the new path " + newFilePath);
        }
        catch (IOException e) {
            return FileUtils.getBallerinaError("FileSystemError", e);
        }
        catch (SecurityException e) {
            return FileUtils.getBallerinaError("PermissionError", e);
        }
    }

    public static BString tempDir() {
        return StringUtils.fromString((String)FileUtils.getSystemProperty(TEMP_DIR_PROPERTY_KEY));
    }

    public static Object createFile(BString path) {
        try {
            Path filepath = Files.createFile(Paths.get(path.getValue(), new String[0]), new FileAttribute[0]);
            return StringUtils.fromString((String)filepath.toAbsolutePath().toString());
        }
        catch (FileAlreadyExistsException e) {
            String msg = "File already exists. Failed to create the file: " + path;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("InvalidOperationError", msg);
        }
        catch (SecurityException e) {
            String msg = "Permission denied. Failed to create the file: " + path;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("PermissionError", msg);
        }
        catch (NoSuchFileException e) {
            String msg = "The file does not exist in path " + path;
            return FileUtils.getBallerinaError("FileSystemError", msg);
        }
        catch (IOException e) {
            String msg = "IO error occurred while creating the file " + path;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("FileSystemError", msg);
        }
        catch (Exception e) {
            String msg = "Error occurred while creating the file " + path;
            log.error(msg, (Throwable)e);
            return FileUtils.getBallerinaError("FileSystemError", msg);
        }
    }

    public static Object getFileInfo(BString path) {
        File inputFile = Paths.get(path.getValue(), new String[0]).toAbsolutePath().toFile();
        if (!inputFile.exists()) {
            return FileUtils.getBallerinaError("FileNotFoundError", "File not found: " + path);
        }
        try {
            return FileUtils.getFileInfo(inputFile);
        }
        catch (IOException e) {
            log.error("IO error while creating the file " + path, (Throwable)e);
            return FileUtils.getBallerinaError("FileSystemError", e);
        }
    }

    public static Object remove(BString path, boolean recursive) {
        File removeFile = Paths.get(path.getValue(), new String[0]).toAbsolutePath().toFile();
        String wdBValue = FileUtils.getSystemProperty(CURRENT_DIR_PROPERTY_KEY);
        File wd = Paths.get(wdBValue, new String[0]).toAbsolutePath().toFile();
        try {
            if (wd.getCanonicalPath().equals(removeFile.getCanonicalPath())) {
                return FileUtils.getBallerinaError("InvalidOperationError", "Cannot delete the current working directory " + wd.getCanonicalPath());
            }
            if (!removeFile.exists()) {
                return FileUtils.getBallerinaError("FileNotFoundError", "File not found: " + removeFile.getCanonicalPath());
            }
            if (recursive) {
                Path directory = Paths.get(removeFile.getCanonicalPath(), new String[0]);
                Files.walkFileTree(directory, new RecursiveFileVisitor());
            } else if (!removeFile.delete()) {
                return FileUtils.getBallerinaError("FileSystemError", "Error while deleting " + removeFile.getCanonicalPath());
            }
            return null;
        }
        catch (IOException ex) {
            return FileUtils.getBallerinaError("FileSystemError", ex);
        }
        catch (SecurityException ex) {
            return FileUtils.getBallerinaError("PermissionError", ex);
        }
    }

    public static Object readDir(BString path, long maxDepth) {
        File inputFile = Paths.get(path.getValue(), new String[0]).toAbsolutePath().toFile();
        if (!inputFile.exists()) {
            return FileUtils.getBallerinaError("FileNotFoundError", "File not found: " + path);
        }
        if (!inputFile.isDirectory()) {
            return FileUtils.getBallerinaError("InvalidOperationError", "File in path " + path + " is not a directory");
        }
        if (maxDepth == -1L) {
            return Utils.readFileTree(inputFile, Integer.MAX_VALUE);
        }
        if (maxDepth > -1L && maxDepth < Integer.MAX_VALUE) {
            return Utils.readFileTree(inputFile, Math.toIntExact(maxDepth));
        }
        return FileUtils.getBallerinaError("InvalidOperationError", "Invalid maxDepth value " + maxDepth);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object readFileTree(File inputFile, int maxDepth) {
        try (Stream<Path> walk = Files.walk(inputFile.toPath(), maxDepth, new FileVisitOption[0]);){
            Object[] results = (ObjectValue[])walk.map(x -> {
                try {
                    ObjectValue objectValue = FileUtils.getFileInfo(x.toFile());
                    fileInfoType = objectValue.getType();
                    return objectValue;
                }
                catch (IOException e) {
                    throw new BallerinaException("Error while accessing file info", (Throwable)e);
                }
            }).skip(1L).toArray(ObjectValue[]::new);
            ArrayValueImpl arrayValueImpl = new ArrayValueImpl(results, new BArrayType(fileInfoType));
            return arrayValueImpl;
        }
        catch (IOException | BallerinaException ex) {
            return FileUtils.getBallerinaError("FileSystemError", ex);
        }
        catch (SecurityException ex) {
            return FileUtils.getBallerinaError("PermissionError", ex);
        }
    }

    public static Object copy(BString sourcePath, BString destinationPath, boolean replaceExisting) {
        Path srcPath = Paths.get(sourcePath.getValue(), new String[0]);
        Path destPath = Paths.get(destinationPath.getValue(), new String[0]);
        if (Files.notExists(srcPath, new LinkOption[0])) {
            return FileUtils.getBallerinaError("FileNotFoundError", "File not found: " + sourcePath);
        }
        try {
            Files.walkFileTree(srcPath, new RecursiveFileCopyVisitor(srcPath, destPath, replaceExisting));
        }
        catch (IOException ex) {
            return FileUtils.getBallerinaError("FileSystemError", ex);
        }
        return null;
    }

    static class RecursiveFileCopyVisitor
    extends SimpleFileVisitor<Path> {
        final Path source;
        final Path target;
        final boolean replaceExisting;

        RecursiveFileCopyVisitor(Path source, Path target, boolean replaceExisting) {
            this.source = source;
            this.target = target;
            this.replaceExisting = replaceExisting;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path newDirectory = this.target.resolve(this.source.relativize(dir));
            if (this.replaceExisting) {
                Files.copy(dir, newDirectory, StandardCopyOption.REPLACE_EXISTING);
            } else {
                try {
                    Files.copy(dir, newDirectory, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException ioException) {
                    log.debug("Directory already exists in the path " + dir.toString() + ", Hence skipping the subtree.");
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path newFile = this.target.resolve(this.source.relativize(file));
            if (this.replaceExisting) {
                Files.copy(file, newFile, StandardCopyOption.REPLACE_EXISTING);
            } else {
                try {
                    Files.copy(file, newFile, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException ioException) {
                    log.debug("File already exists in the path " + file.toString() + ", Hence skipping the subtree.");
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }

    static class RecursiveFileVisitor
    extends SimpleFileVisitor<Path> {
        RecursiveFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

