/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.file.service.endpoint;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.stdlib.file.service.DirectoryListenerConstants;
import org.ballerinalang.stdlib.file.utils.FileUtils;

public class InitEndpoint {
    public static Object initEndpoint(ObjectValue listener) {
        String path = listener.getMapValue(DirectoryListenerConstants.SERVICE_ENDPOINT_CONFIG).getStringValue(DirectoryListenerConstants.ANNOTATION_PATH).getValue();
        if (path == null || path.isEmpty()) {
            return FileUtils.getBallerinaError("FileSystemError", "'path' field is empty");
        }
        Path dirPath = Paths.get(path, new String[0]);
        if (Files.notExists(dirPath, new LinkOption[0])) {
            return FileUtils.getBallerinaError("FileSystemError", "Folder does not exist: " + path);
        }
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            return FileUtils.getBallerinaError("FileSystemError", "Unable to find a directory: " + path);
        }
        return null;
    }
}

