/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.file.service.endpoint;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.util.exceptions.BallerinaConnectorException;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.stdlib.file.service.DirectoryListenerConstants;
import org.ballerinalang.stdlib.file.service.FSListener;
import org.ballerinalang.stdlib.file.utils.FileUtils;
import org.wso2.transport.localfilesystem.server.connector.contract.LocalFileSystemListener;
import org.wso2.transport.localfilesystem.server.connector.contract.LocalFileSystemServerConnector;
import org.wso2.transport.localfilesystem.server.connector.contractimpl.LocalFileSystemConnectorFactoryImpl;
import org.wso2.transport.localfilesystem.server.exception.LocalFileSystemServerConnectorException;

public class Register {
    public static Object register(ObjectValue listener, ObjectValue service, Object name) {
        MapValue serviceEndpointConfig = listener.getMapValue(DirectoryListenerConstants.SERVICE_ENDPOINT_CONFIG);
        try {
            Map<String, AttachedFunction> resourceRegistry = Register.getResourceRegistry(service);
            String events = String.join((CharSequence)",", resourceRegistry.keySet());
            Map<String, String> paramMap = Register.getParamMap(serviceEndpointConfig, events);
            LocalFileSystemConnectorFactoryImpl connectorFactory = new LocalFileSystemConnectorFactoryImpl();
            LocalFileSystemServerConnector serverConnector = connectorFactory.createServerConnector(service.getType().getName(), paramMap, (LocalFileSystemListener)new FSListener(BRuntime.getCurrentRuntime(), service, resourceRegistry));
            listener.addNativeData("serverConnector", (Object)serverConnector);
        }
        catch (LocalFileSystemServerConnectorException e) {
            return FileUtils.getBallerinaError("FileSystemError", "Unable to initialize server connector: " + e.getMessage());
        }
        return null;
    }

    private static Map<String, AttachedFunction> getResourceRegistry(ObjectValue service) {
        AttachedFunction[] attachedFunctions;
        HashMap<String, AttachedFunction> registry = new HashMap<String, AttachedFunction>(5);
        block10: for (AttachedFunction resource : attachedFunctions = service.getType().getAttachedFunctions()) {
            switch (resource.getName()) {
                case "onCreate": {
                    registry.put("create", resource);
                    continue block10;
                }
                case "onDelete": {
                    registry.put("delete", resource);
                    continue block10;
                }
                case "onModify": {
                    registry.put("modify", resource);
                    continue block10;
                }
            }
        }
        if (registry.size() == 0) {
            String msg = "At least a single resource required from following: onCreate ,onDelete ,onModify. Parameter should be of type - file:FileEvent";
            throw new BallerinaConnectorException(msg);
        }
        return registry;
    }

    private static Map<String, String> getParamMap(MapValue serviceEndpointConfig, String events) {
        String path = serviceEndpointConfig.getStringValue(DirectoryListenerConstants.ANNOTATION_PATH).getValue();
        boolean recursive = serviceEndpointConfig.getBooleanValue(DirectoryListenerConstants.ANNOTATION_DIRECTORY_RECURSIVE);
        HashMap<String, String> paramMap = new HashMap<String, String>(3);
        if (path != null && !path.isEmpty()) {
            paramMap.put("dirURI", path);
        }
        paramMap.put("events", events);
        paramMap.put("recursive", String.valueOf(recursive));
        return paramMap;
    }
}

