/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.file.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.time.ZonedDateTime;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.StringUtils;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.stdlib.file.utils.FileConstants;
import org.ballerinalang.stdlib.time.util.TimeUtils;

public class FileUtils {
    private static final String UNKNOWN_MESSAGE = "Unknown Error";

    public static ErrorValue getBallerinaError(String error, Throwable ex) {
        String errorMsg = error != null && ex.getMessage() != null ? ex.getMessage() : UNKNOWN_MESSAGE;
        return FileUtils.getBallerinaError(error, errorMsg);
    }

    public static ErrorValue getBallerinaError(String error, String message) {
        return BallerinaErrors.createDistinctError((String)error, (BPackage)FileConstants.FILE_PACKAGE_ID, (String)(message != null ? message : UNKNOWN_MESSAGE));
    }

    public static ObjectValue getFileInfo(File inputFile) throws IOException {
        FileTime lastModified = Files.getLastModifiedTime(inputFile.toPath(), new LinkOption[0]);
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(lastModified.toString());
        MapValue lastModifiedInstance = TimeUtils.createTimeRecord((MapValue)TimeUtils.getTimeZoneRecord(), (MapValue)TimeUtils.getTimeRecord(), (long)lastModified.toMillis(), (BString)StringUtils.fromString((String)zonedDateTime.getZone().toString()));
        return BallerinaValues.createObjectValue((BPackage)FileConstants.FILE_PACKAGE_ID, (String)"FileInfo", (Object[])new Object[]{StringUtils.fromString((String)inputFile.getName()), inputFile.length(), lastModifiedInstance, inputFile.isDirectory(), StringUtils.fromString((String)inputFile.getAbsolutePath())});
    }

    public static String getSystemProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            return (String)BTypes.typeString.getZeroValue();
        }
        return value;
    }

    private FileUtils() {
    }
}

