/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.format;

public class Messages {
    private static final String ARGUMENT_ERROR = "too many arguments." + System.lineSeparator() + "usage: only one argument, either a ballerina file name or a module name, can be applied at a time with or without the option." + System.lineSeparator() + "i.e: ballerina format [ballerinaFile | ModuleName] [-d | --dry-run]" + System.lineSeparator() + System.lineSeparator() + "run `ballerina format -h` for more details.";
    private static final String SUCCESS_MESSAGE = "format successful.";
    private static final String NOT_BALLERINA_PROJECT = "not a valid Ballerina project." + System.lineSeparator() + "usage: ballerina format should be run inside a ballerina project or pass in a ballerina file." + System.lineSeparator() + "i.e. `ballerina format <ballerina-file>`" + System.lineSeparator() + System.lineSeparator() + "run `ballerina format -h` for more details";
    private static final String NO_MODULE_FOUND = "couldn't find an existing module by the name: ";
    private static final String EXCEPTION = "something went wrong when formatting." + System.lineSeparator();
    private static final String NO_BALLERINA_FILE = "couldn't find an existing ballerina file by the name: ";
    private static final String NOT_BALLERINA_FILE = "not a valid ballerina source file." + System.lineSeparator() + "usage: ballerina source files should have the file extension as `.bal`." + System.lineSeparator() + "i.e. `ballerina format hello.bal`";
    private static final String NO_BALLERINA_FILE_OR_MODULE = "couldn't find an existing ballerina file or module by the name: ";
    private static final String NO_CHANGES = "no changes.";
    private static final String FILES_TO_MODIFY = "files to be modified:";
    private static final String MODIFIED_FILES = "modified files:";

    static String getArgumentError() {
        return ARGUMENT_ERROR;
    }

    static String getSuccessMessage() {
        return SUCCESS_MESSAGE;
    }

    static String getNotBallerinaProject() {
        return NOT_BALLERINA_PROJECT;
    }

    static String getNoModuleFound(String moduleName) {
        return NO_MODULE_FOUND + moduleName;
    }

    static String getException() {
        return EXCEPTION;
    }

    static String getNoBallerinaFile(String fileName) {
        return NO_BALLERINA_FILE + fileName;
    }

    static String getNoBallerinaModuleOrFile(String fileName) {
        return NO_BALLERINA_FILE_OR_MODULE + fileName;
    }

    static String getNotABallerinaFile() {
        return NOT_BALLERINA_FILE;
    }

    static String getNoChanges() {
        return NO_CHANGES;
    }

    static String getFilesToModify() {
        return FILES_TO_MODIFY;
    }

    static String getModifiedFiles() {
        return MODIFIED_FILES;
    }
}

