/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.servicestub;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import io.grpc.MethodDescriptor;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.exception.GrpcClientException;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.StructInfo;

abstract class AbstractExecute
extends BlockingNativeCallableUnit {
    AbstractExecute() {
    }

    BType getBalType(String protoType, Context context) {
        if (protoType.equalsIgnoreCase("DoubleValue") || protoType.equalsIgnoreCase("FloatValue")) {
            return BTypes.typeFloat;
        }
        if (protoType.equalsIgnoreCase("Int32Value") || protoType.equalsIgnoreCase("Int64Value") || protoType.equalsIgnoreCase("UInt32Value") || protoType.equalsIgnoreCase("UInt64Value")) {
            return BTypes.typeInt;
        }
        if (protoType.equalsIgnoreCase("BoolValue")) {
            return BTypes.typeBoolean;
        }
        if (protoType.equalsIgnoreCase("StringValue")) {
            return BTypes.typeString;
        }
        if (protoType.equalsIgnoreCase("BytesValue")) {
            return BTypes.typeBlob;
        }
        return context.getProgramFile().getEntryPackage().getStructInfo(protoType).getType();
    }

    MethodDescriptor.MethodType getMethodType(Descriptors.MethodDescriptor methodDescriptor) throws GrpcClientException {
        if (methodDescriptor == null) {
            throw new GrpcClientException("Error while processing method type. Method descriptor cannot be null.");
        }
        DescriptorProtos.MethodDescriptorProto methodDescriptorProto = methodDescriptor.toProto();
        return MessageUtils.getMethodType(methodDescriptorProto);
    }

    BStruct createStruct(Context context, String structName) {
        PackageInfo httpPackageInfo = context.getProgramFile().getPackageInfo("ballerina.grpc");
        StructInfo structInfo = httpPackageInfo.getStructInfo(structName);
        BStructType structType = structInfo.getType();
        return new BStruct(structType);
    }

    void notifyErrorReply(Context context, String errorMessage) {
        PackageInfo errorPackageInfo = context.getProgramFile().getPackageInfo("ballerina.builtin");
        StructInfo errorStructInfo = errorPackageInfo.getStructInfo("error");
        BStruct outboundError = new BStruct(errorStructInfo.getType());
        outboundError.setStringField(0, errorMessage);
        context.setError(outboundError);
    }
}

