/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.net.grpc.config.EndpointConfiguration;
import org.ballerinalang.net.grpc.ssl.SSLConfig;
import org.ballerinalang.util.exceptions.BallerinaException;

public class EndpointUtils {
    private static final Pattern VAR_PATTERN = Pattern.compile("\\$\\{([^}]*)}");

    public static EndpointConfiguration getEndpointConfiguration(Struct endpointConfig) {
        String host = endpointConfig.getStringField("host");
        long port = endpointConfig.getIntField("port");
        Struct sslConfig = endpointConfig.getStructField("ssl");
        EndpointConfiguration endpointConfiguration = new EndpointConfiguration();
        if (host == null || host.isEmpty()) {
            endpointConfiguration.setHost("localhost");
        } else {
            endpointConfiguration.setHost(host);
        }
        endpointConfiguration.setPort(Math.toIntExact(port));
        if (!(sslConfig == null || "".equals(sslConfig.getStringField("trustStoreFile")) && "".equals(sslConfig.getStringField("keyStoreFile")))) {
            endpointConfiguration.setScheme("https");
            endpointConfiguration.setSslConfig(EndpointUtils.getSslConfig(sslConfig));
            return endpointConfiguration;
        }
        return endpointConfiguration;
    }

    private static SSLConfig getSslConfig(Struct sslConfig) {
        String keyStoreFile = sslConfig.getStringField("keyStoreFile");
        String keyStorePassword = sslConfig.getStringField("keyStorePassword");
        String trustStoreFile = sslConfig.getStringField("trustStoreFile");
        String trustStorePassword = sslConfig.getStringField("trustStorePassword");
        String sslVerifyClient = sslConfig.getStringField("sslVerifyClient");
        String certPassword = sslConfig.getStringField("certPassword");
        String sslProtocol = sslConfig.getStringField("sslProtocol");
        String tlsStoreType = sslConfig.getStringField("tlsStoreType");
        sslProtocol = sslProtocol != null && !"".equals(sslProtocol) ? sslProtocol : "TLS";
        tlsStoreType = tlsStoreType != null && !"".equals(tlsStoreType) ? tlsStoreType : "PKCS12";
        boolean validateCertificateEnabled = sslConfig.getBooleanField("validateCertEnabled");
        long cacheSize = sslConfig.getIntField("cacheSize");
        long cacheValidationPeriod = sslConfig.getIntField("cacheValidityPeriod");
        if (keyStoreFile == null) {
            throw new BallerinaConnectorException("Keystore location must be provided for secure connection");
        }
        if (keyStorePassword == null) {
            throw new BallerinaConnectorException("Keystore password value must be provided for secure connection");
        }
        if (certPassword == null) {
            throw new BallerinaConnectorException("Certificate password value must be provided for secure connection");
        }
        if (trustStoreFile == null && sslVerifyClient != null) {
            throw new BallerinaException("Trust store location must be provided to enable Mutual SSL");
        }
        if (trustStorePassword == null && sslVerifyClient != null) {
            throw new BallerinaException("Trust store password value must be provided to enable Mutual SSL");
        }
        SSLConfig config = new SSLConfig();
        config.setTLSStoreType("PKCS12");
        config.setKeyStore(new File(EndpointUtils.substituteVariables(keyStoreFile)));
        config.setKeyStorePass(keyStorePassword);
        config.setCertPass(certPassword);
        config.setTLSStoreType(tlsStoreType);
        config.setSslVerifyClient(sslVerifyClient);
        if (trustStoreFile != null) {
            config.setTrustStore(new File(EndpointUtils.substituteVariables(trustStoreFile)));
            config.setTrustStorePass(trustStorePassword);
        }
        config.setValidateCertificateEnabled(validateCertificateEnabled);
        if (validateCertificateEnabled) {
            config.setCacheSize(Math.toIntExact(cacheSize));
            config.setCacheValidityPeriod(Math.toIntExact(cacheValidationPeriod));
        }
        config.setSslProtocol(sslProtocol);
        return config;
    }

    private static String substituteVariables(String filePath) {
        Matcher matcher = VAR_PATTERN.matcher(filePath);
        boolean found = matcher.find();
        if (!found) {
            return filePath;
        }
        StringBuffer sb = new StringBuffer();
        do {
            String sysPropKey;
            String sysPropValue;
            if ((sysPropValue = EndpointUtils.getSystemVariableValue(sysPropKey = matcher.group(1))) == null || sysPropValue.length() == 0) {
                throw new RuntimeException("System property " + sysPropKey + " is not specified");
            }
            sysPropValue = sysPropValue.replace("\\", "\\\\");
            matcher.appendReplacement(sb, sysPropValue);
        } while (matcher.find());
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String getSystemVariableValue(String variableName) {
        String value = null;
        if (System.getProperty(variableName) != null) {
            value = System.getProperty(variableName);
        } else if (System.getenv(variableName) != null) {
            value = System.getenv(variableName);
        }
        return value;
    }
}

