/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.clientresponder;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="errorResponse", receiver=@Receiver(type=TypeKind.STRUCT, structType="ClientResponder", structPackage="ballerina.grpc"), args={@Argument(name="serverError", type=TypeKind.STRUCT, structType="ServerError", structPackage="ballerina.grpc"), @Argument(name="headers", type=TypeKind.ARRAY)}, returnType={@ReturnType(type=TypeKind.STRUCT, structType="ConnectorError", structPackage="ballerina.grpc")}, isPublic=true)
public class ErrorResponse
extends BlockingNativeCallableUnit {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorResponse.class);
    private static final int MESSAGE_HEADER_REF_INDEX = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Context context) {
        BStruct endpointClient = (BStruct)context.getRefArgument(0);
        BRefValueArray headerValues = (BRefValueArray)context.getRefArgument(1);
        BValue responseValue = context.getRefArgument(1);
        io.grpc.Context msgContext = MessageUtils.getContextHeader(headerValues);
        if (responseValue instanceof BStruct) {
            BStruct responseStruct = (BStruct)responseValue;
            int statusCode = Integer.parseInt(String.valueOf(responseStruct.getIntField(0)));
            String errorMsg = responseStruct.getStringField(0);
            StreamObserver<Message> responseObserver = MessageUtils.getResponseObserver((BRefType)endpointClient);
            if (responseObserver == null) {
                context.setError(MessageUtils.getConnectorError(context, (Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.INTERNAL.getCode()).withDescription("Error while sending the error. Response observer not found."))));
            } else {
                io.grpc.Context previous = msgContext != null ? msgContext.attach() : null;
                try {
                    responseObserver.onError((Throwable)new StatusRuntimeException(Status.fromCodeValue((int)statusCode).withDescription(errorMsg)));
                }
                finally {
                    if (previous != null) {
                        msgContext.detach(previous);
                    }
                }
            }
        }
    }
}

