/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.connection.client;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.grpc.MessageUtils;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="errorResponse", receiver=@Receiver(type=TypeKind.STRUCT, structType="ClientConnection", structPackage="ballerina.grpc"), args={@Argument(name="serverError", type=TypeKind.STRUCT, structType="ClientError", structPackage="ballerina.grpc")}, returnType={@ReturnType(type=TypeKind.STRUCT, structType="ConnectorError", structPackage="ballerina.grpc")}, isPublic=true)
public class ErrorResponse
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        BStruct connectionStruct = (BStruct)context.getRefArgument(0);
        BValue responseValue = context.getRefArgument(1);
        if (responseValue instanceof BStruct) {
            BStruct responseStruct = (BStruct)responseValue;
            int statusCode = Integer.parseInt(String.valueOf(responseStruct.getIntField(0)));
            String errorMsg = responseStruct.getStringField(0);
            StreamObserver requestSender = (StreamObserver)connectionStruct.getNativeData("REQUEST_SENDER");
            if (requestSender == null) {
                context.setError(MessageUtils.getConnectorError(context, (Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.INTERNAL.getCode()).withDescription("Error while sending the error. Response observer not found."))));
            } else {
                requestSender.onError((Throwable)new StatusRuntimeException(Status.fromCodeValue((int)statusCode).withDescription(errorMsg)));
            }
        }
    }
}

