/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.headers;

import io.grpc.Metadata;
import java.util.Base64;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.grpc.MessageHeaders;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="get", receiver=@Receiver(type=TypeKind.STRUCT, structType="Headers", structPackage="ballerina.grpc"), args={@Argument(name="headerName", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.STRING)}, isPublic=true)
public class Get
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        String headerName = context.getStringArgument(0);
        BStruct headerValues = (BStruct)context.getRefArgument(0);
        MessageHeaders metadata = headerValues != null ? (MessageHeaders)headerValues.getNativeData("Metadata") : null;
        String headerValue = this.getHeaderValue(metadata, headerName);
        if (headerValue != null) {
            context.setReturnValues(new BValue[]{new BString(headerValue)});
        } else {
            context.setReturnValues(new BValue[0]);
        }
    }

    private String getHeaderValue(MessageHeaders metadata, String keyName) {
        String headerValue = null;
        if (metadata != null) {
            if (keyName.endsWith("-bin")) {
                Metadata.Key key = Metadata.Key.of((String)keyName, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
                byte[] byteValues = (byte[])metadata.get(key);
                headerValue = byteValues != null ? Base64.getEncoder().encodeToString(byteValues) : null;
            } else {
                Metadata.Key key = Metadata.Key.of((String)keyName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                headerValue = (String)metadata.get(key);
            }
        }
        return headerValue;
    }
}

